<?php

use Source\Support\Helper;
use CoffeeCode\Cropper\Cropper;

$c = new Cropper("cache");
$v->layout('inc/layout');
?>

<section class="container bg-silver padding-high">
    <div class="content">
        <header class="header-default mb-80">
            <h1 class="f-semibold" style="color: rgba(36,64,133,0.5)">O Partido</h1>
            <h2 class="f-semibold f-black">Partido Social Democrático</h2>
            <p class="f-black f-light text-page">Conheça a história, Princípios e Valores</p>
        </header>

        <div class="content-total-about">
            <div class="flex-container flex-wrap">
                <div class="flex flex60">
                    <div class="container padding-total-normal bg-white radius-m">
                        <!--<h2 class="title-page-sec f-black f-semibold mb-30">Trajetória</h2>-->
                        <div class="about-text">
                            <p class="f-black f-light t-justify mb-20">
                                Em ato público em São Paulo, em 22 de março de 2011, foram anunciadas pela primeira vez algumas diretrizes em torno das quais se uniriam forças políticas de todas o País para a formação do Partido Social Democrático. Redigido pelo então vice-governador de São Paulo, Guilherme Afif, e lido por ele mesmo naquele dia, esse documento […]
                            </p>

                            <p class="f-black f-light t-justify mb-20">
                                Em ato público em São Paulo, em 22 de março de 2011, foram anunciadas pela primeira vez algumas diretrizes em torno das quais se uniriam forças políticas de todas o País para a formação do Partido Social Democrático. Redigido pelo então vice-governador de São Paulo, Guilherme Afif, e lido por ele mesmo naquele dia, esse documento de quatro páginas continha as linhas gerais de atuação do futuro PSD, que foram reafirmadas, dias depois, no lançamento nacional do partido, em Salvador, na Bahia. Seis meses depois, em 28 de setembro, após receber do Tribunal Superior Eleitoral a sua certidão de nascimento, o PSD divulgou um Manifesto à Nação. Lido em Brasília pelo presidente nacional, Gilberto Kassab, o manifesto consolida os princípios e valores que, acima e além de carimbos ideológicos, são defendidos pelo PSD, indicam seus rumos e orientam suas ações.
                            </p>

                            <p class="f-black f-light t-justify mb-20">
                                O partido Social Democrático tem posição clara na defesa das liberdades de expressão e opinião e ao direito do cidadão à informação. Somos, por convicção e princípio, contra qualquer tipo de censura, controle, restrição ou regulamentação da mídia.
                            </p>

                            <p class="f-black f-light t-justify mb-20">
                                O PSD será também intransigente na condenação e denúncia pública da corrupção e dos malfeitos. Está ao lado da sociedade, do trabalhador, dos jovens, da família brasileira que exigem respeito ao dinheiro público e comportamento ético, coerência e honestidade de seus governantes e da classe política.
                            </p>

                            <p class="f-black f-light t-justify mb-20">
                                O exercício da política tem de ser responsável, transparente, não comporta conluios, conchavos ou sombras.
                            </p>

                            <p class="f-black f-light t-justify mb-20">
                                O PSD defende o voto distrital, com introdução gradual, inicialmente nos 85 municípios com 200 mil ou mais eleitores onde hoje há segundo turno.
                            </p>

                            <p class="f-black f-light t-justify mb-20">
                                Defendemos a iniciativa e a propriedade privadas, a economia de mercado como o regime capaz de gerar riqueza e desenvolvimento, sem os quais não se erradica a pobreza. Acreditamos num estado forte, regulador, mas democrático e centrado nas suas prioridades sociais.
                            </p>
                            
                            <p class="f-black f-light t-justify mb-20">
                                Apoiamos as políticas sociais aos que mais precisam do amparo do estado, e a necessidade de abrir as portas de entrada do emprego digno para esses cidadãos. Devemos isso ao Brasil que quer e precisa se modernizar, se tornar mais ágil, se libertar das impossibilidades e oferecer, de verdade, igualdade de oportunidade aos que querem se profissionalizar, gerir seu próprio negócio e vencer na vida. O PSD contará com a experiência de algumas das mais importantes lideranças sindicais do Brasil para  defender políticas de inclusão social e desenvolvimento trabalhista.
                            </p>
                            
                            <p class="f-black f-light t-justify mb-20">
                                O PSD aposta na agricultura e na pecuária – como parte da cadeia produtiva do agronegócio – que libertou do atraso histórico as populações do campo, transformando antigos proprietários rurais em empresários e criando uma nova classe de trabalhadores especializados e valorizados. Mas fazemos questão de lembrar e valorizar a multidão de pequenos produtores, uma classe batalhadora que carrega o Brasil nas costas.
                            </p>
                            
                            <p class="f-black f-light t-justify mb-20">
                                O PSD apoia e defende a preservação do meio ambiente como fator de sobrevivência do homem e da própria vida do planeta. É possível alargar as fronteiras da produção, de maneira sustentável e responsável.
                            </p>
                            
                            <p class="f-black f-light t-justify mb-20">
                                O PSD exige a exposição clara, em todos os produtos comercializados, de todos os impostos ocultos nos preços dos bens e serviços, para que o cidadão saiba o que paga e o que tem direito a receber de volta do Estado. Pago, logo exijo: esse é o cidadão alerta e ativo que queremos.
                            </p>
                            
                            <p class="f-black f-light t-justify mb-20">
                                O PSD não fará oposição pela oposição. Faremos política para ajudar o Brasil. Nossos adversários não são inimigos a eliminar, mas cidadãos com os quais vamos dialogar, sem violências ou radicalismos.
                            </p>
                            
                            <p class="f-black f-light t-justify mb-20">
                                Temos democracia, direitos, liberdade, conquistas e avanços sociais. Nossa Constituição está aí, em pleno funcionamento. Mas temos ainda enormes desigualdades sociais, fome e injustiças.
                            </p>
                            
                            <p class="f-black f-light t-justify mb-20">
                                Sem violentar direitos e liberdades já conquistados, vamos enfrentar os pontos fundamentais que estão travando e obstruindo o desenvolvimento do Brasil. Com nossas crenças e uma constituinte exclusiva em 2014, vamos à luta unidos para construir um País mais moderno e desenvolvido, mais ético, justo, e solidário.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="flex flex40 pl-30">
                    <article class="container mb-30">
                        <?= Helper::image($c->make(THEME . '/images/img1.jpg', 900, 600), 'Sobre a Meta', 'img radius-m') ?>
                    </article>
                    
                    <article class="container mb-30">
    <!-- Adicionando um container com estilo de opacidade -->
    <div style="opacity: 0.7;">
        <?= Helper::image($c->make(THEME . '/images/img1.jpg', 900, 600), 'Sobre a Meta', 'img radius-m') ?>
    </div>
</article>
                    
                    <article class="container mb-30">
    <!-- Adicionando um container com estilo de opacidade -->
    <div style="opacity: 0.5;">
        <?= Helper::image($c->make(THEME . '/images/img1.jpg', 900, 600), 'Sobre a Meta', 'img radius-m') ?>
    </div>
</article>

<article class="container mb-30">
    <!-- Adicionando um container com estilo de opacidade -->
    <div style="opacity: 0.3;">
        <?= Helper::image($c->make(THEME . '/images/img1.jpg', 900, 600), 'Sobre a Meta', 'img radius-m') ?>
    </div>
</article>

<article class="container mb-30">
    <!-- Adicionando um container com estilo de opacidade -->
    <div style="opacity: 0.1;">
        <?= Helper::image($c->make(THEME . '/images/img1.jpg', 900, 600), 'Sobre a Meta', 'img radius-m') ?>
    </div>
</article>

                    <!--<article class="container mb-30">
                        <?= Helper::image($c->make(THEME . '/images/img2.jpg', 800, 700), 'Sobre a Meta', 'img radius-m') ?>
                    </article>

                    <article class="container">
                        <?= Helper::image($c->make(THEME . '/images/img3.jpg', 800, 700), 'Sobre a Meta', 'img radius-m') ?>
                    </article>-->
                </div>
            </div>
        </div>
    </div>
</section>