<?php
    
    namespace Source\Models\Web;
    
    use Source\Support\Helper;
    
    class Message
    {
        private $data;
        private $result;
        private $error;
        
        public function send(array $data)
        {
            $this->data = $data;
            $phone = $this->data['phone'];
            unset($this->data['phone']);
            
            if (in_array('', $this->data)):
                $this->result = false;
                $this->error = [
                    "Erro ao cadastrar: Você precisa preencher todos os campos obrigatórios para cadastrar a sua mensagem.",
                    ERROR
                ];
            elseif (!Helper::email($this->data['email'])):
                $this->result = false;
                $this->error = [
                    "Erro ao cadastrar: Você precisa preencher um e-mail com formato válido para cadastrar a sua mensagem.",
                    ERROR
                ];
            else:
                $this->data['phone'] = $phone;
                $this->create();
            endif;
        }
        
        public function result()
        {
            return $this->result;
        }
        
        public function error()
        {
            return $this->error;
        }
        
        private function create()
        {
            $message = new \Source\Models\Message();
            $message->name = $this->data['name'];
            $message->email = $this->data['email'];
            $message->phone = $this->data['phone'];
            $message->subject = $this->data['subject'];
            $message->status = 1;
            $message->description = $this->data['description'];
            
            $create = $message->save();
            if (!$create):
                $this->result = false;
                $this->error = [
                    "Erro ao cadastrar: Não foi possível cadastrar a sua mensagem.",
                    ERROR
                ];
            else:
                $this->result = true;
                $this->error = [
                    "Tudo certo: Sua mensagem foi cadastrada com sucesso.",
                    ACCEPT
                ];
            endif;
        }
    }