<?php
    
    namespace Source\Models\Admin;
    
    use Source\Models\Message;
    
    class AdminMessage
    {
        private $msg;
        private $id;
        private $result;
        private $error;
        
        public function updateStatus(int $id)
        {
            $this->id = $id;
            $this->msg = (new Message())->findById($this->id);
            $this->msg->status = 0;
            
            $update = $this->msg->save();
            if (!$update):
                $this->result = false;
            else:
                $this->result = true;
            endif;
        }
        
        public function exeDelete(int $id)
        {
            $this->id = $id;
            $this->msg = (new Message())->findById($this->id);
            
            if (!$this->msg):
                $this->error = [
                    "<b class='f-bold'>Erro ao excluir:</b> Não foi possível encontrar a mensagem do sistema.",
                    ERROR
                ];
                $this->result = false;
            else:
                $delete = $this->msg->destroy();
                if (!$delete):
                    $this->error = [
                        "<b class='f-bold'>Erro ao excluir:</b> Não foi possível excluir a mensagem do sistema.",
                        ERROR
                    ];
                    $this->result = false;
                else:
                    $this->error = [
                        "<b class='f-bold'>Tudo certo:</b> A mensagem foi excluída com sucesso do sistema.",
                        ACCEPT
                    ];
                    $this->result = true;
                endif;
            endif;
        }
        
        public function result()
        {
            return $this->result;
        }
        
        public function error()
        {
            return $this->error;
        }
    }