<?php

namespace Source\App\Web;

use League\Plates\Engine;
use CoffeeCode\Optimizer\Optimizer;

class About
{
    private $template;
    private $optimizer;

    public function __construct($router)
    {
        $this->template = Engine::create(THEME, FILE_EXT);
        $this->optimizer = new Optimizer();

        $this->template->addData([
            "router" => $router
        ]);
    }

    public function index()
    {
        echo $this->template->render("o-partido", [
            /** MetaTags */
            "optimizer" => $this->optimizer->optimize(
                "O Partido | " . SITE_TITLE,
                SITE_DESC,
                HOME . "/o-partido",
                HOME . "/theme/images/index.jpg"
            )->render()
        ]);
    }

    public function psd()
    {
        echo $this->template->render("psd-mulher", [
            /** MetaTags */
            "optimizer" => $this->optimizer->optimize(
                "PSD Mulher | " . SITE_TITLE,
                SITE_DESC,
                HOME . "/psd-mulher",
                HOME . "/theme/images/index.jpg"
            )->render()
        ]);
    }
    
    public function publi()
    {
        echo $this->template->render("publi", [
            /** MetaTags */
            "optimizer" => $this->optimizer->optimize(
                "Publicações | " . SITE_TITLE,
                SITE_DESC,
                HOME . "/publicacoes",
                HOME . "/theme/images/index.jpg"
            )->render()
        ]);
    }

    public function reports()
    {
        echo $this->template->render("psd-jovem", [
            /** MetaTags */
            "optimizer" => $this->optimizer->optimize(
                "PSD Jovem | " . SITE_TITLE,
                SITE_DESC,
                HOME . "/psd-jovem",
                HOME . "/theme/images/index.jpg"
            )->render()
        ]);
    }

    public function pronouncements()
    {
        echo $this->template->render("espaco-democratico", [
            /** MetaTags */
            "optimizer" => $this->optimizer->optimize(
                "Espaço Democrático | " . SITE_TITLE,
                SITE_DESC,
                HOME . "/espaco-democratico",
                HOME . "/theme/images/index.jpg"
            )->render()
        ]);
    }
}
