<?php
$v->layout('inc/dashboard');
?>

<div class="box-full mb-50">
    <header class="pb-60">
        <h1 class="title-page f-black f-semibold mb-10">
            <i class="icon-write mr-10"></i> Novo cadastro
        </h1>
        <div class="nav float_l">
            <ul>
                <li class="t-upper">
                    <a href="<?= HOME ?>"><?= COMPANY_NAME ?></a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/admin">Dashboard</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/admin/records">Cadastros</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/admin/records/create">Novo cadastro</a>
                </li>
            </ul>
        </div>

        <nav class="options-default">
            <a href="<?= HOME ?>/admin/records" class="btn btn-icon-medio btn-blue radius-g"><i class="icon-arrow-left2"></i></a>
        </nav>
    </header>
</div>

<div class="box-full">
    <form action="" method="post" class="j_formajax" enctype="multipart/form-data">
        <div class="box box70">
            <input type="hidden" name="callback" value="<?= $router->route('record.manager') ?>" class="noclear">

            <div class="box box100">
                <div class="box-full padding-total-normal radius-p box-white mb-30" style="border: 1px solid seagreen;">
                    <h3 class="title-page-sec f-semibold f-black t-upper">Dados pessoais:</h3>
                </div>
            </div>

            <label class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Nome Completo <span class="f-red">*</span></small>
                <input type="text" name="name" required class="form input-form-larg" placeholder="Nome">
            </label>
            
            <label class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Sobrenome <span class="f-red">*</span></small>
                <input type="text" name="lastname" required class="form input-form-larg" placeholder="Sobrenome">
            </label>


            <label class="box box50">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Gênero <span class="f-red">*</span></small>
                <div class="select">
                    <select name="genre" class="select-medio" required>
                        <option value="" selected disabled>Selecione um gênero</option>
                        <?php
                        foreach (getGenre() as $k => $v) :
                            echo "<option value='{$k}'>{$v}</option>";
                        endforeach;
                        ?>
                    </select>
                </div>
            </label>

            <label class="box box50">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Nascimento <span class="f-red">*</span></small>
                <input type="text" name="birth" required class="form input-form-medio formAniver" placeholder="dd/mm/aaaa">
            </label>
            
            
            <label class="box box50">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Número do Título </small>
                <input type="text" name="titulo" class="form input-form-larg" placeholder="Núm. Título">
            </label>
            
            <label class="box box50">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Número da Zona </small>
                <input type="text" name="zona" class="form input-form-larg" placeholder="Núm Zona">
            </label>
            
            <label class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Nome da Escola </small>
                <input type="text" name="escola" class="form input-form-larg" placeholder="Nome da Escola">
            </label>

            <div class="box box100">
                <div class="box-full padding-total-normal radius-p box-white mb-30 mt-30" style="border: 1px solid seagreen;">
                    <h3 class="title-page-sec f-semibold f-black t-upper">Dados de contato:</h3>
                </div>
            </div>

            <label class="box box50">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Celular / Whatsapp <span class="f-red">*</span></small>
                <input type="text" name="phone" required class="form input-form-medio formFone" placeholder="Celular">
            </label>

            <div class="box box100">
                <div class="box-full padding-total-normal radius-p box-white mb-30 mt-30" style="border: 1px solid seagreen;">
                    <h3 class="title-page-sec f-semibold f-black t-upper">Dados de endereço:</h3>
                </div>
            </div>

            <!-- <label class="box box33">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Estado <span class="f-red">*</span></small>
                <div class="select">
                    <select name="state" id="state" class="select-medio" rel="<? //= $router->route('citys.get') 
                                                                                ?>" required>
                        <option value="" selected disabled>Selecione um estado</option>
                        <?php
                        if ($states) :
                            foreach ($states as $state) :
                                echo "<option value='{$state->uf}'>{$state->uf} - {$state->name}</option>";
                            endforeach;
                        endif;
                        ?>
                    </select>
                </div>
            </label> -->

            <label class="box box50">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Cidade <span class="f-red">*</span></small>
                <div class="select">
                    <select name="city" id="city" class="select-medio" rel="<?= $router->route('districts.get') ?>" required>
                        <option value="" selected disabled>Selecione uma cidade</option>
                        <?php
                        if ($citys) :
                            foreach ($citys as $city) :
                                echo "<option value='{$city->id}'>{$city->name}</option>";
                            endforeach;
                        endif;
                        ?>
                    </select>
                </div>
            </label>

            <label class="box box50">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Bairro <span class="f-red">*</span></small>
                <div class="select">
                    <select name="district" id="district" class="select-medio" required>
                        <option value="" selected disabled>Selecione um bairro</option>
                    </select>
                </div>
            </label>

            <div class="box box100">
                <div class="box-full padding-total-normal radius-p box-white mb-30 mt-30" style="border: 1px solid seagreen;">
                    <h3 class="title-page-sec f-semibold f-black t-upper">Levantamento de dados do bairro:</h3>
                </div>
            </div>

            <label class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">O que é você no seu bairro? <span class="f-red">*</span></small>
                <div class="select">
                    <select name="type_personal" class="select-medio" required>
                        <option value="" selected disabled>Selecione uma opção</option>
                        <?php
                        foreach (getTypePersonal() as $k => $v) :
                            echo "<option value='{$k}'>{$v}</option>";
                        endforeach;
                        ?>
                    </select>
                </div>
            </label>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">QUAL O MEIO VOCÊ MAIS UTILIZA PARA SE INFORMAR?</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php foreach (getMethodComunication() as $k => $v) : ?>
                        <article class="mb-10">
                            <input type="checkbox" value="<?= $k ?>" name="methods_comunication[]" id="check_1_<?= $k ?>">
                            <label for="check_1_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">O QUE SEU BAIRRO MAIS PRECISA?</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php foreach (getNeedDistrict() as $k => $v) : ?>
                        <article class="mb-10">
                            <input type="checkbox" value="<?= $k ?>" name="district_need[]" id="check_2_<?= $k ?>">
                            <label for="check_2_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">SANEAMENTO</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php foreach (getNeedDistrictSanitation() as $k => $v) : ?>
                        <article class="mb-10">
                            <input type="checkbox" value="<?= $k ?>" name="district_need_sanitation[]" id="check_3_<?= $k ?>">
                            <label for="check_3_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">ESTRADAS</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php foreach (getNeedDistrictRoads() as $k => $v) : ?>
                        <article class="mb-10">
                            <input type="checkbox" value="<?= $k ?>" name="district_need_roads[]" id="check_4_<?= $k ?>">
                            <label for="check_4_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">EDUCAÇÃO</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php foreach (getNeedDistrictEducation() as $k => $v) : ?>
                        <article class="mb-10">
                            <input type="checkbox" value="<?= $k ?>" name="district_need_education[]" id="check_5_<?= $k ?>">
                            <label for="check_5_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">SAÚDE</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php foreach (getNeedDistrictHealth() as $k => $v) : ?>
                        <article class="mb-10">
                            <input type="checkbox" value="<?= $k ?>" name="district_need_health[]" id="check_6_<?= $k ?>">
                            <label for="check_6_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">ESPORTE</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php foreach (getNeedDistrictSports() as $k => $v) : ?>
                        <article class="mb-10">
                            <input type="checkbox" value="<?= $k ?>" name="district_need_sports[]" id="check_7_<?= $k ?>">
                            <label for="check_7_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">CULTURA</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php foreach (getNeedDistrictCulture() as $k => $v) : ?>
                        <article class="mb-10">
                            <input type="checkbox" value="<?= $k ?>" name="district_need_culture[]" id="check_8_<?= $k ?>">
                            <label for="check_8_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">MEIO AMBIENTE</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php foreach (getNeedDistrictEnvironment() as $k => $v) : ?>
                        <article class="mb-10">
                            <input type="checkbox" value="<?= $k ?>" name="district_need_environment[]" id="check_9_<?= $k ?>">
                            <label for="check_9_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">SEGURANÇA</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php foreach (getNeedDistrictSecurity() as $k => $v) : ?>
                        <article class="mb-10">
                            <input type="checkbox" value="<?= $k ?>" name="district_need_security[]" id="check_10_<?= $k ?>">
                            <label for="check_10_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">HABITAÇÃO</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php foreach (getNeedDistrictHabitation() as $k => $v) : ?>
                        <article class="mb-10">
                            <input type="checkbox" value="<?= $k ?>" name="district_need_habitation[]" id="check_11_<?= $k ?>">
                            <label for="check_11_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">DESENVOLVIMENTO ECONÔMICO</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php foreach (getNeedDistrictEconomy() as $k => $v) : ?>
                        <article class="mb-10">
                            <input type="checkbox" value="<?= $k ?>" name="district_need_economy[]" id="check_12_<?= $k ?>">
                            <label for="check_12_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">TRANSPORTE COLETIVO</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php foreach (getNeedDistrictTransport() as $k => $v) : ?>
                        <article class="mb-10">
                            <input type="checkbox" value="<?= $k ?>" name="district_need_transport[]" id="check_13_<?= $k ?>">
                            <label for="check_13_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">MELHORIAS NA URBANIZAÇÃO</small>
                <div class="flex-container flex-direction-column pl-20 mt-20">
                    <?php foreach (getNeedDistrictUrban() as $k => $v) : ?>
                        <article class="mb-10">
                            <input type="checkbox" value="<?= $k ?>" name="district_need_urban[]" id="check_14_<?= $k ?>">
                            <label for="check_14_<?= $k ?>"><?= $v ?></label>
                        </article>
                    <?php endforeach; ?>
                </div>
            </div>

            <div class="box box100 flex-container flex-itens-center flex-justify-space-between">
                <p style="font-size: 12px;" class="f-black f-light t-upper"><span class="f-red">*</span> Campos obrigatórios</p>
                <button class="btn btn-medio btn-green radius-g">
                    <i class="icon-check-alt mr-5"></i> Finalizar cadastro
                </button>
            </div>
    </form>
</div>

<div class="trigger-box"></div>