<?php

use Source\Support\Helper;
use CoffeeCode\Cropper\Cropper;

$c = new Cropper("cache");
$v->layout('inc/dashboard');
$level = $_SESSION['acesso']['nivel'];
$permission = ($level == 1 || $level == 2 ? true : false);
?>

<div class="box-full mb-50">
    <header class="pb-60">
        <h1 class="title-page f-black f-semibold mb-10">
            <i class="icon-home4 mr-10"></i> Dashboard
        </h1>
        <div class="nav float_l">
            <ul>
                <li class="t-upper">
                    <a href="<?= HOME ?>"><?= COMPANY_NAME ?></a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/painel.php">Dashboard</a>
                </li>
            </ul>
        </div>
    </header>
</div>

<div class="box-full mb-50">
    <div class="content-numbers-resume">
        <article class="box <?= (!$permission ? 'box100' : 'box33') ?>">
            <div class="box-full box-white">
                <div class="btn-icon-larg round users">
                    <i class="icon-users1 f-green"></i>
                </div>
                <p class="mt-15 t-center f-bold f-black">
                    <span class="j_count"><?= $numberRecord ?></span>
                    <small class="f-semibold">Cadastros</small>
                </p>
            </div>
        </article>

        <?php if ($permission) : ?>
            <article class="box box33">
                <div class="box-full box-white">
                    <div class="btn-icon-larg round posts">
                        <i class="icon-comment-alt2-stroke f-blue"></i>
                    </div>
                    <p class="mt-15 t-center f-bold f-black">
                        <span class="j_count"><?= $numberPost ?></span>
                        <small class="f-semibold">Posts</small>
                    </p>
                </div>
            </article>

            <article class="box box33">
                <div class="box-full box-white">
                    <div class="btn-icon-larg round msgs">
                        <i class="icon-envelope f-purple"></i>
                    </div>
                    <p class="mt-15 t-center f-bold f-black">
                        <span class="j_count"><?= $numberMsg ?></span>
                        <small class="f-semibold">Mensagens</small>
                    </p>
                </div>
            </article>
        <?php endif; ?>
    </div>
</div>

<div class="box-full mb-20">
    <div class="box box100">
        <div class="box-full box-white padding-total-normal">
            <h2 class="title-page-sec f-black f-semibold mb-10">
                <i class="icon-chart1 mr-10"></i> Necessidades dos bairros/cidades
            </h2>
            <p class="f-light f-silver subtitle-page mb-30">
                Veja as principais necessidades dos bairros e/ou cidades nos últimos meses:
            </p>

            <div class="j_chart">
                <canvas id="myChart"></canvas>
            </div>
        </div>
    </div>
</div>

<div class="box-full mb-20">
    <div class="box box33">
        <div class="box-full box-white padding-total-normal">
            <h2 class="title-page-sec f-black f-semibold mb-30">
                <i class="icon-chart1 mr-10"></i> Meios de comunicação
            </h2>
            <canvas id="myChart2" width="400" height="400"></canvas>
        </div>
    </div>

    <div class="box box33">
        <div class="box-full box-white padding-total-normal">
            <h2 class="title-page-sec f-black f-semibold mb-30">
                <i class="icon-chart1 mr-10"></i> Tipo de entrevistado
            </h2>
            <canvas id="myChart3" width="400" height="400"></canvas>
        </div>
    </div>

    <div class="box box33">
        <div class="box-full box-white padding-total-normal">
            <h2 class="title-page-sec f-black f-semibold mb-30">
                <i class="icon-chart1 mr-10"></i> Entrevistados por gênero
            </h2>
            <canvas id="myChart4" width="400" height="400"></canvas>
        </div>
    </div>
</div>

<?php if ($permission) : ?>
    <div class="box-full mb-20">
        <div class="box box50 content-last-posts">
            <div class="box-full box-white padding-total-normal">
                <h2 class="title-page-sec f-black f-semibold mb-10">
                    <i class="icon-comment-alt2-stroke mr-10"></i> Posts mais vistos
                </h2>
                <p class="f-light f-silver subtitle-page mb-30">Acompanhe os
                    <span class="f-semibold">3 posts</span> mais visualizados:
                </p>

                <?php foreach ($postsViews as $po) : ?>
                    <article class="box-full box-silver padding-total-low radius-m mb-20">
                        <a href="<?= HOME ?>/admin/posts/update/<?= $po->id ?>">
                            <div class="photo float_l">
                                <?= Helper::image($c->make("{$po->cover}", 1150, 700), "{$po->title}", "img radius-m") ?>
                            </div>
                            <header>
                                <h1 class="f-bold f-black mb-10"><?= $po->title ?></h1>
                                <p class="f-silver f-semibold">
                                    <i class="icon-eye2"></i> <?= $po->view ?> Visualizações
                                </p>
                            </header>
                        </a>
                    </article>
                <?php endforeach; ?>
            </div>
        </div>

        <div class="box box50 content-browsers">
            <div class="box-full box-white padding-total-normal">
                <h2 class="title-page-sec f-black f-semibold mb-10">
                    <i class="icon-earth mr-10"></i> Visitas por navegador
                </h2>
                <p class="f-light f-silver subtitle-page mb-30">Acompanhe os índices de visitas por navegador:</p>

                <?php
                foreach ($browsers as $ag) :
                    $agentName = ($ag->name == 'Chrome' ? 'Google Chrome' : ($ag->name == 'Firefox' ? 'Mozilla Firefox' : ($ag->name == 'Internet Explorer' ? 'Internet Explorer' : 'Outros')));
                    $agentIcon = ($ag->name == 'Chrome' ? 'icon-chrome' : ($ag->name == 'Firefox' ? 'icon-firefox' : ($ag->name == 'Internet Explorer' ? 'fa fa-internet-explorer' : 'icon-earth')));
                    $agentColor = ($ag->name == 'Chrome' ? 'chrome' : ($ag->name == 'Firefox' ? 'firefox' : ($ag->name == 'Internet Explorer' ? 'ie' : 'out')));

                    //PORCENTAGEM
                    $percent = substr(($ag->views / $totalViewBrowsers) * 100, 0, 4);
                ?>
                    <h3 class="f-semibold f-silver t-upper mb-5">
                        <i class="<?= $agentIcon ?>"></i> <?= $agentName ?>
                    </h3>
                    <article class="mb-20 radius-g box-silver <?= $agentColor ?>">
                        <div style="width: <?= $percent ?>%" class="padding-total-low radius-g <?= $agentColor ?>">
                            <p class="f-semibold t-upper f-white t-center"><?= $percent ?>%</p>
                        </div>
                    </article>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
<?php endif; ?>

<?= $v->insert('js/charts'); ?>