<?php
    $v->layout('inc/dashboard');
?>

<div class="box-full mb-50">
    <header class="pb-60">
        <h1 class="title-page f-black f-semibold mb-10">
            <i class="icon-envelope mr-10"></i> Mensagens
        </h1>
        <div class="nav float_l">
            <ul>
                <li class="t-upper">
                    <a href="<?= HOME ?>"><?= COMPANY_NAME ?></a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/admin">Dashboard</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/admin/messages">Mensagens</a>
                </li>
            </ul>
        </div>
    </header>
</div>

<div class="box-full">
    <div class="box box100">
        <?= $paginator ?>
        <div class="content-table">
            <table class="table box-full" cellspacing="0" cellpadding="0">
                <tr class="box-silver t-upper">
                    <td class="f-bold f-black tb-field">#</td>
                    <td class="f-bold f-black tb-field">Nome</td>
                    <td class="f-bold f-black tb-field on-desktop">E-mail</td>
                    <td class="f-bold f-black tb-field">Data de Envio</td>
                    <td class="f-bold f-black tb-field">&nbsp;</td>
                </tr>
                <?php
                    $color = 'box-silver';
                    if ($msg):
                        $i = 0;
                        foreach ($msg as $m):
                            $i++;
                            $color = ($color == 'box-silver' ? 'box-white' : 'box-silver');
                            $new = ($m->status == 1 ? 'icon-notification f-red' : 'icon-check-alt f-green');
                            $tool = ($m->status == 1 ? 'Nova mensagem!' : 'Mensagem lida!');
                            $i = ($i <= 9 ? '0' . $i : $i);
                            ?>
                            <tr class="<?= $color ?>">
                                <td class="f-light f-black tb-field">
                                    <i class="<?= $new ?> j_tooltip" title="<?= $tool ?>"></i>
                                </td>
                                <td class="f-light f-black tb-field"><?= $m->name ?></td>
                                <td class="f-light f-black tb-field on-desktop"><?= $m->email ?></td>
                                <td class="f-light f-black tb-field"><?= date('d/m/Y H:i', strtotime($m->created_at)) ?>h</td>
                                <td class="f-light f-black tb-field j_list t-right">
                                    <a href="<?= HOME ?>/admin/messages/read/<?= $m->id ?>" class="btn btn-icon-medio btn-green round"><i class="icon-eye2"></i></a>
                                    <a rel="<?= $m->id ?>" id="messages/read/delete" class="btn btn-icon-medio btn-red round j_delete"><i class="icon-trash"></i></a>
                                </td>
                            </tr>
                        <?php
                        endforeach;
                    endif;
                ?>
            </table>
        </div>
    </div>
</div>

<div class="trigger-box"></div>