$(document).ready(function () {
    // HEADER FIX
    var contentHeader = $('.content-header');
    var headerFix = $('.header-fix');
    $(window).scroll(function () {
        if ($(document).scrollTop() > contentHeader.height()) {
            headerFix.addClass('show');
        } else {
            headerFix.removeClass('show');
        }
    });

    //GET CEP
    $('.sg_getCep').keyup(function () {
        var cep = $(this).val().replace('-', '').replace('.', '').replace('_', '');

        if (cep.length === 8) {
            $.get("https://viacep.com.br/ws/" + cep + "/json", function (data) {
                if (!data.erro) {
                    $('.sg_bairro').val(data.bairro);
                    $('.sg_complemento').val(data.complemento);
                    $('.sg_localidade').val(data.localidade);
                    $('.sg_logradouro').val(data.logradouro);
                    $('.sg_uf').val(data.uf);
                } else {
                    $('.trigger-box').html('<div class="trigger-modal error"><h4><i class="fa fa-close"></i> Erro!</h4> Não foi possível encontrar o endereço através do CEP informado. Por favor, <b>insira seu endereço manualmente.</b> <span class="trigger-close"><i class="fa fa-close"></i></span></div>');
                    $('.trigger-modal').fadeIn();

                    $('.trigger-modal .trigger-close').click(function () {
                        $('.trigger-box .trigger-modal').fadeOut(function () {
                            $(this).remove();
                        });
                    });

                    $('.sg_logradouro').removeClass('box-silver').attr('readonly', false);
                    $('.sg_bairro').removeClass('box-silver').attr('readonly', false);
                    $('.sg_localidade').removeClass('box-silver').attr('readonly', false);
                    $('.sg_uf').removeClass('box-silver').attr('readonly', false);
                }
            }, 'json');
        }
    });

    $('.handleClickDoubt').click(function () {
        let box = $('.content-doubts-list');
        let id = $(this).attr('rel');
        let desc = $('#' + id);
        box.find('article .title .desc').hide();
        desc.show();
    });

    // TABS DEFAULT
    $('.nav-tab ul li a').click(function (event) {
        var Rel = $(this).attr('rel');

        if (Rel != 'link') {
            event.preventDefault();
            $(this).parent().addClass("current");
            $(this).parent().siblings().removeClass("current");
            var tab = $(this).attr("href");
            $(".tabs").not(tab).css("display", "none");
            $(tab).fadeIn();
        }
    });

    // CORE LINKS
    $('a[href^="#"]').on('click', function (e) {
        e.preventDefault();

        var Core = $(this).attr('rel');

        var target = this.hash,
            $target = $(target);

        if (Core == 'core') {
            $('html, body').stop().animate({
                'scrollTop': $target.offset().top
            }, 900, 'swing', function () {
                window.location.hash = target;
            });
        }
    });

    // GESTÃO DE JANELA MODAL
    $('.btn_modal').click(function () {
        var modal = $(this).attr('rel');

        $('.mask-modal').fadeIn();
        $('.form_load').fadeIn().delay(400).fadeOut(100, function () {
            $('.content-modal').fadeIn().css('display', 'flex');
            $('#' + modal).fadeIn();
        });
    });

    $('.close_modal').click(function () {
        $('.mask-modal').fadeOut(300);
        $('.content-modal').fadeOut(300);
        $('.modal').fadeOut(300);
    });

    $('.j_change1').change(function () {
        var callback = $(this).attr('id');
        var Change1 = $('.j_change1');
        var Change2 = $('.j_change2');

        Change1.attr('disabled', 'true');
        Change2.attr('disabled', 'true');

        Change2.html('<option value="">Carregando...</option>');

        $.post(callback, {
            id: $(this).val()
        }, function (data) {
            Change2.html(data).removeAttr('disabled');
            Change1.removeAttr('disabled');
        });
    });

    $(document).ready(function () {
        // MENU ANCHOR
        $('.menu-anchor').on('click touchstart', function (e) {
            $('html').toggleClass('menu-active');
            e.preventDefault();
        });

        // SHADOWBOX
        Shadowbox.init();
    });

    $('.j_btn_whatsapp').click(function () {
        $('.whatsapp-form').addClass('active');
    });
    $('.j_btn_whatsapp_close').click(function () {
        $('.whatsapp-form').removeClass('active');
    });

    setTimeout(function () {
        let cookieConsent = getCookie("user_cookie_consent");
        if (!cookieConsent) {
            $('.modal_lgpd').fadeIn();
        } else {
            $('.modal_lgpd').fadeOut();
        }
    }, 3000);
});

$(window).load(function () {
    //Controla Contents
    var box1 = $('.j_team1');
    var box2 = $('.j_team2');

    var height1 = box1.height();
    var height2 = box2.height();

    box2.height(height1);
});

function acceptCookie() {
    setCookie('user_cookie_consent', 1, 30);
    $('.modal_lgpd').fadeOut();
}

function deleteCookie(name) {
    const d = new Date();
    d.setTime(d.getTime() + (24 * 60 * 60 * 1000));
    let expires = "expires=" + d.toUTCString();
    document.cookie = name + "=;" + expires + ";path=/";
}

function setCookie(name, value, days) {
    const d = new Date();
    d.setTime(d.getTime() + (days * 24 * 60 * 60 * 1000));
    let expires = "expires=" + d.toUTCString();
    document.cookie = name + "=" + value + ";" + expires + ";path=/";
}

function getCookie(cname) {
    let name = cname + "=";
    let decodedCookie = decodeURIComponent(document.cookie);
    let ca = decodedCookie.split(';');
    for (let i = 0; i < ca.length; i++) {
        let c = ca[i];
        while (c.charAt(0) == ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
            return c.substring(name.length, c.length);
        }
    }
    return false;
}

// INICIA SHADOWBOX
Shadowbox.init();