<?php
    
    use Source\Support\Helper;
    use CoffeeCode\Cropper\Cropper;
    
    $c = new Cropper("cache");
    
    $v->layout('inc/dashboard');
?>

<div class="box-full mb-50">
    <header class="pb-60">
        <h1 class="title-page f-black f-semibold mb-10">
            <i class="icon-comment-alt2-stroke mr-10"></i> Novo Post
        </h1>
        <div class="nav float_l">
            <ul>
                <li class="t-upper">
                    <a href="<?= HOME ?>"><?= COMPANY_NAME ?></a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/admin">Dashboard</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/admin/posts">Posts</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/admin/posts/create">Novo Post</a>
                </li>
            </ul>
        </div>

        <nav class="options-default">
            <a href="<?= HOME ?>/admin/posts" class="btn btn-icon-medio btn-blue radius-g"><i class="icon-arrow-left2"></i></a>
        </nav>
    </header>
</div>

<div class="box-full">
    <form action="" method="post" class="j_formajax" enctype="multipart/form-data">
        <input type="hidden" name="callback" value="manager" class="noclear">

        <div class="box box60">
            <label class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Título do post</small>
                <input type="text" name="title" required class="form input-form-larg" placeholder="Título do post">
            </label>

            <label class="box box40">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Cód. do vídeo</small>
                <input type="text" name="video" class="form input-form-larg" placeholder="Cód. do vídeo">
            </label>

            <label class="box box100 mt-20">
                <div class="box-full padding-total-low radius-m box-white">
                    <textarea name="description" id="elm1"></textarea>
                </div>
            </label>
        </div>

        <div class="box box40">
            <label class="box box100 mt-15" style="cursor:pointer;">
                <img id="blah" src="#" class="mb-20 radius-m" style="display: none"/>
                <?= Helper::image($c->make(ADMIN . "/images/cover.jpg", 1150, 650), "Selecione uma capa", "img radius-m mb-20 j_cover") ?>
                <small class="small-titulo-2 f-silver f-semibold t-upper">Foto de capa</small>
                <input type="file" name="cover" required class="form input-form-medio file box-white" onchange="readURL(this);">
            </label>

            <label class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Tipo</small>
                <div class="select">
                    <select name="type" required class="select-medio">
                        <option value="" selected disabled>Selecione um tipo</option>
                        <?php foreach (getTypePost() as $k => $v): ?>
                            <option value="<?= $k ?>"><?= $v ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </label>

            <label class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Categoria</small>
                <div class="select">
                    <select name="category" required class="select-medio">
                        <option value="" selected disabled>Selecione uma categoria</option>
                        <?php foreach ($cate as $c): ?>
                            <option value="<?= $c->id ?>"><?= $c->title ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </label>

            <div class="box box100">
                <button class="btn btn-medio btn-green radius-g float_r">
                    <i class="icon-check-alt mr-5"></i> Cadastrar
                </button>

                <div class="float_r mr-20 mt-15">
                    <input type="checkbox" value="1" name="status" id="check">
                    <label for="check">Publicar</label>
                </div>
            </div>
        </div>
    </form>
</div>