<?php

namespace Source\App\Admin;

use League\Plates\Engine;
use CoffeeCode\Paginator\Paginator;
use Source\Models\Admin\AdminDash;
use Source\Models\Admin\AdminMessage;

class Message
{
    private $template;

    public function __construct()
    {
        $this->template = Engine::create(ADMIN, FILE_EXT);
        $session = new AdminDash();
        $validate = $session->checkSession();
        if (!$validate) :
            header('Location:' . HOME . "/admin");
        endif;

        $checkLevel = $session->checkLevel($_SESSION['acesso']['nivel'], [1, 2]);
        if (!$checkLevel) :
            header('Location:' . HOME . "/admin");
        endif;
    }

    public function index($data)
    {
        $page = filter_input(INPUT_GET, "page", FILTER_VALIDATE_INT);
        $msg = new \Source\Models\Message();
        /*
             * PAGINATOR
             */
        $paginator = new Paginator(HOME . "/admin/messages&page=", "Página", [
            "Primeira Página",
            "Primeira"
        ], [
            "Última Página",
            "Última"
        ]);
        $paginator->pager($msg->find()->count(), 50, $page, 2);

        $messages = $msg->find()->order("created_at DESC")->limit($paginator->limit())->offset($paginator->offset())->fetch(true);

        echo $this->template->render("system/messages/index", [
            /** Data Page */
            "paginator" => $paginator->render(),
            "msg" => $messages,
        ]);
    }

    public function read($data)
    {
        $msg = new \Source\Models\Message();
        $message = $msg->findById($data['id']);

        if (!$message) :
            header('Location:' . HOME . '/admin/messages');
        else :
            $adminMessage = new AdminMessage();
            $adminMessage->updateStatus($data['id']);
        endif;

        echo $this->template->render("system/messages/read", [
            /** Data Page */
            "msg" => $message
        ]);
    }

    public function delete($data)
    {
        sleep(1);
        $json = [];

        $setPost = array_map("strip_tags", $data);
        $post = array_map("trim", $setPost);

        $id = (isset($post['id']) ? $post['id'] : false);

        if ($id) :
            $adminMessage = new AdminMessage();
            $adminMessage->exeDelete($id);
            if (!$adminMessage->result()) :
                $json['error'] = $adminMessage->error()[0];
            else :
                $json['accept'] = $adminMessage->error()[0];
                $json['redirect'] = HOME . "/admin/messages";
                $json['time'] = 2000;
            endif;
        else :
            $json['error'] = "Não foi possivel processar a operação";
        endif;

        echo json_encode($json);
    }
}
