<?php

use Source\Support\Helper;
use CoffeeCode\Cropper\Cropper;

$c = new Cropper("cache");
$v->layout('inc/layout');
?>

<section class="container bg-silver padding-high">
    <div class="content">
        <header class="header-default mb-80">
            <h1 class="f-semibold" style="color: rgba(139,202,167,0.5)">Biografia</h1>
            <h2 class="f-semibold f-black">Miguel Gualberto</h2>
            <p class="f-black f-light text-page">Conheça a minha história</p>
        </header>

        <div class="content-total-about">
            <div class="flex-container flex-wrap">
                <div class="flex flex60">
                    <div class="container padding-total-normal bg-white radius-m">
                        <h2 class="title-page-sec f-black f-semibold mb-30">Trajetória</h2>
                        <div class="about-text">
                            <p class="f-black f-light t-justify mb-20">
                                Nasceu em Araguacema, no Tocantins, em 18 em de setembro de 1959. Trabalhou
                                como comerciário, técnico em contabilidade e servidor público municipal. É
                                funcionário licenciado do Banco da Amazônia. Formou-se em Pedagogia pela
                                Universidade do Estado do Pará (UEPA), em Teologia pela Faculdade João Calvino
                                (DF) e Contabilidade pela Fundação Bradesco – Escola Ministro Jarbas Gonçalves
                                Passarinho – Conceição do Araguaia – Pará.
                            </p>

                            <p class="f-black f-light t-justify mb-20">
                                Evangelista da Assembleia de Deus, é membro da Convenção de Ministros e Igrejas
                                Assembleia de Deus do Estado do Pará – COMIEADEPA e Convenção Geral das
                                Assembleias de Deus no Brasil – CGADB.
                            </p>

                            <p class="f-black f-light t-justify mb-20">
                                Iniciou sua vida política em 1992 como candidato a prefeito – quando, mesmo não
                                se elegendo, obteve a notoriedade política que o levou a concorrer a uma vaga
                                na Assembleia Legislativa, nas eleições de 1994, chegando à primeira suplência
                                e assumindo o mandato em 1997. Em 1998, é reeleito ao cargo de Deputado Estadual.
                            </p>

                            <p class="f-black f-light t-justify mb-20">
                                Pensando em contribuir ainda mais com o Pará, em 2002, Zequinha se candidatou
                                ao cargo de Deputado Federal e foi eleito. Manteve-se representante paraense
                                na Câmara dos Deputados por três mandatos consecutivos, tendo sido eleito
                                presidente da Comissão de Legislação Participativa (CLP) e vice-presidente
                                da Comissão de Integração Nacional, Desenvolvimento Regional e da Amazônia
                                (CINDRA) e atuado ativamente em diversas comissões.
                            </p>

                            <p class="f-black f-light t-justify mb-20">
                                Em 2014, representou sua gente na função de vice-governador do Pará. Tornou-se
                                o primeiro vice-governador da Região Sul do estado do Pará. Em 2018, foi eleito
                                para defender os interesses dos paraenses no Senado Federal. Considerado um
                                dos maiores líderes políticos do interior do Pará e um dos pouquíssimos
                                parlamentares que obteve votos em todos os 144 municípios paraenses, em
                                todas as eleições que concorreu para o congresso nacional.
                            </p>

                            <p class="f-black f-light t-justify mb-20">
                                No Senado, foi nomeado presidente da Comissão Mista de Mudanças Climáticas (CMMC),
                                assim como assumiu a presidência da Subcomissão de Acompanhamento das Obras de
                                Belo Monte e das Frentes Parlamentares em Defesa do Consumidor de Energia Elétrica
                                da Região Norte e em Defesa da Amazônia Legal.
                            </p>

                            <p class="f-black f-light t-justify mb-20">
                                Além disso, é membro de nove Comissões Permanentes do Senado e, em 2019, perante
                                a Comissão Mista de Orçamento (um dos principais colegiados do Congresso Nacional)
                                foi escolhido por seus pares para ser relator da Receita do Orçamento de 2020
                                – missão de grande relevância para ajudar a União a reduzir o déficit fiscal
                                e aumentar o volume de investimentos no país.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="flex flex40 pl-30">
                    <article class="container mb-30">
                        <?= Helper::image($c->make(THEME . '/images/img1.jpg', 800, 900), 'Sobre a Meta', 'img radius-m') ?>
                    </article>

                    <article class="container mb-30">
                        <?= Helper::image($c->make(THEME . '/images/img2.jpg', 800, 900), 'Sobre a Meta', 'img radius-m') ?>
                    </article>

                    <!--<article class="container">
                        <?= Helper::image($c->make(THEME . '/images/img3.jpg', 800, 700), 'Sobre a Meta', 'img radius-m') ?>
                    </article>-->
                </div>
            </div>
        </div>
    </div>
</section>