<?php

use Source\App\Web\Publish;

$publish = new Publish();
?>

<!DOCTYPE html>
<html lang="pt-br">
<meta name="viewport" content="width=device-width" />

<head>
    <meta charset="UTF-8">
    <?= $optimizer ?>
    <?= $publish->getPublish(); ?>

    <!-- FAVICON -->
    <link rel="icon" href="<?= INCLUDE_PATH ?>/images/favicon.png">

    <!-- JS -->
    <script src="<?= HOME ?>/shared/jquery.js"></script>
    <script src="<?= HOME ?>/shared/jquery.form.js"></script>
    <script src="<?= HOME ?>/shared/jquery-mask.js"></script>
    <script src="<?= HOME ?>/shared/jquery.maskmoney.js"></script>
    <script src="<?= HOME ?>/shared/mask.js?cache=<?= CACHE_VERSION ?>"></script>
    <script src="<?= HOME ?>/shared/datepicker.js?cache=<?= CACHE_VERSION ?>"></script>
    <script src="<?= HOME ?>/shared/jquery-ui.js"></script>
    <script src="<?= HOME ?>/shared/shadowbox/shadowbox.js"></script>
    <script src="<?= HOME ?>/shared/scrollreveal.js"></script>
    <script src="<?= INCLUDE_PATH ?>/js/slick.min.js"></script>
    <script src="<?= INCLUDE_PATH ?>/js/script.js?cache=<?= CACHE_VERSION ?>"></script>
    <script src="<?= INCLUDE_PATH ?>/js/coreControl.js?cache=<?= CACHE_VERSION ?>"></script>
    <script src="<?= INCLUDE_PATH ?>/js/scriptAjax.js?cache=<?= CACHE_VERSION ?>"></script>

    <!-- CSS -->
    <link rel="stylesheet" href="<?= HOME ?>/shared/shadowbox/shadowbox.css">
    <link rel="stylesheet" type="text/css" href="<?= HOME ?>/shared/font-awesome/css/font-awesome.css">
    <link rel="stylesheet" type="text/css" href="<?= HOME ?>/shared/icomoon/style.css">
    <link rel="stylesheet" type="text/css" href="<?= INCLUDE_PATH ?>/css/reset.css?cache=<?= CACHE_VERSION ?>">
    <link rel="stylesheet" type="text/css" href="<?= INCLUDE_PATH ?>/css/style.css?cache=<?= CACHE_VERSION ?>">
    <link rel="stylesheet" type="text/css" href="<?= INCLUDE_PATH ?>/css/slick.css">

    <!-- PAGAR.ME -->
    <script src="https://assets.pagar.me/pagarme-js/4.5/pagarme.min.js"></script>
</head>

<body>
    <div class="mask-modal"></div>
    <div class="form_load">
        <div class="loading-icon">
            <span></span>
            <span></span>
            <span></span>
            <span></span>
        </div>
    </div>
    <div class="trigger-box"></div>
    <?php
    echo $v->insert('inc/mobile');
    echo $v->insert('inc/header');
    echo $v->section('content');
    echo $v->insert('inc/footer');
    ?>

    <!-- WHATSAPP BUTTON -->
    <a class="btn_whatsapp_fixed j_btn_whatsapp round">
        <div class="whatsapp-msg radius-m">
            <div class="dote"></div>
            <h2 class="f-semibold f-white">Está com dúvidas?</h2>
            <p class="f-light f-white">Entre em contato pelo WhatsApp!</p>
        </div>
        <i class="icon-whatsapp"></i>
    </a>

    <div class="whatsapp-form transition">
        <a class="close-form j_btn_whatsapp_close round"><i class="icon-x"></i></a>
        <div class="whatsapp-header padding-total-low t-center">
            <h2 class="f-white f-semibold mb-5">Você já vai para o WhatsApp!</h2>
            <p class="f-white f-light">Mas antes, preencha os campos abaixo para que possamos lhe conhecer melhor:</p>
        </div>
        <div class="whatsapp-main bg-silver padding-total-low">
            <form action="<?= HOME ?>/whatsapp/send" method="post" target="_blank">
                <div class="mb-10">
                    <small class="small-titulo f-silver f-light t-upper">Nome completo:</small>
                    <input type="text" required name="name" placeholder="Nome completo" class="form input-form-medio radius-p">
                </div>
                <div class="mb-5">
                    <small class="small-titulo f-silver f-light t-upper">Mensagem:</small>
                    <textarea required name="message" placeholder="Mensagem" class="form area-form-medio radius-p"></textarea>
                </div>
                <div>
                    <button class="btn btn-low radius-p box100">
                        <i class="icon-whatsapp mr-5"></i> Falar com um atendente
                    </button>
                </div>
            </form>
        </div>
    </div>

    <div class="modal_lgpd radius-m">
        <div class="container bg-white padding-total-normal radius-m">
            <h2 class="f-semibold f-black mb-10">Uso de Cookies</h2>
            <p class="f-light f-black">Este site utiliza cookies para oferecer uma melhor experiência de
                navegação para os visitantes. Ao clicar no botão "Aceitar", você concorda com o uso de cookies no nosso site.</p>
            <div class="mt-20">
                <a onclick="acceptCookie()" class="btn btn-low btn-blue radius-p">Aceitar cookies</a>
            </div>
        </div>
    </div>

    <script type="text/javascript">
        window.sr = ScrollReveal({
            reset: false
        });
        sr.reveal('.reveal_top', {
            duration: 800,
            origin: 'top',
            distance: "40px"
        });
        sr.reveal('.reveal_bottom', {
            duration: 800,
            origin: 'bottom',
            distance: "40px"
        });
        sr.reveal('.reveal_left', {
            duration: 800,
            origin: 'left',
            distance: "40px"
        });
        sr.reveal('.reveal_right', {
            duration: 800,
            origin: 'right',
            distance: "40px"
        });
    </script>
</body>

</html>