<?php
    
    use Source\Models\Post;
    use Source\Models\Category;
    
    $v->layout('inc/dashboard');
?>

<div class="box-full mb-50">
    <header class="pb-60">
        <h1 class="title-page f-black f-semibold mb-10">
            <i class="icon-list-nested mr-10"></i> Categorias
        </h1>
        <div class="nav float_l">
            <ul>
                <li class="t-upper">
                    <a href="<?= HOME ?>"><?= COMPANY_NAME ?></a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/admin">Dashboard</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/admin/categories">Categorias</a>
                </li>
            </ul>
        </div>

        <nav class="options-default">
            <a href="<?= HOME ?>/admin/categories/create" class="btn btn-icon-medio btn-blue radius-g"><i class="icon-write"></i></a>
        </nav>
    </header>
</div>

<div class="box-full mb-50">
    <div class="box box100">
        <div class="content-cate">
            <?php
                if ($parents):
                    foreach ($parents as $pa):
                        $posts = (new Post())->find("parent = :p", "p={$pa->id}")->count();
                        ?>
                        <article class="box-parent box-full box-white">
                            <header class="box-blue box-full padding-total-normal">
                                <h1 class="f-bold f-white"><?= $pa->title ?></h1>
                                <p class="date t-upper f-bold f-white">
                                    <i class="icon-comment-alt2-stroke"></i> <?= $posts ?> Posts
                                </p>
                                <p class="date t-upper f-bold f-white">
                                    <i class="fa fa-clock-o"></i> Cadastrada em <?= date('d/m/Y H:i', strtotime($pa->created_at)) ?>h
                                </p>

                                <nav class="options-default box_2 float_r">
                                    <a href="<?= HOME ?>/blog/categorias/<?= $pa->uri ?>" target="_blank" class="btn btn-icon-medio btn-yellow round"><i class="icon-eye2"></i></a>
                                    <a href="<?= HOME ?>/admin/categories/update/<?= $pa->id ?>" class="btn btn-medio btn-green radius-g"><i class="icon-write"></i> Editar</a>
                                </nav>
                            </header>
                            <main class="box-white padding-total-low box100 float_l">
                                <?php
                                    $categories = (new Category())->find("parent = :p", "p={$pa->id}")->order("title ASC")->fetch(true);
                                    if ($categories):
                                        foreach ($categories as $c):
                                            $posts = (new Post())->find("category = :c", "c={$c->id}")->count();
                                            ?>
                                            <div class="box box50">
                                                <div class="box-full box-cate padding-total-low radius-m box-silver">
                                                    <header>
                                                        <h1 class="f-bold f-black"><?= $c->title ?></h1>
                                                        <p class="date t-upper f-bold f-black">
                                                            <i class="icon-comment-alt2-stroke"></i> <?= $posts ?> Posts
                                                        </p>
                                                        <div class="line" style="margin-top: 7px"></div>
                                                        <div class="clear"></div>
                                                        <a href="<?= HOME ?>/blog/categorias/<?= $c->uri ?>" target="_blank" class="btn btn-icon-medio btn-blue round f-white"><i class="icon-eye2"></i></a>
                                                        <a href="<?= HOME ?>/admin/categories/update/<?= $c->id ?>" class="btn btn-icon-medio btn-green round f-white"><i class="icon-write"></i></a>
                                                    </header>
                                                </div>
                                            </div>
                                        <?php
                                        endforeach;
                                    endif;
                                ?>
                            </main>
                        </article>
                    <?php
                    endforeach;
                endif;
            ?>
        </div>
    </div>
</div>

<div class="trigger-box"></div>