<?php
    
    namespace Source\Models\Admin;
    
    use Source\Models\Contact;
    
    class AdminContact
    {
        private $data;
        private $result;
        private $error;
        private $id;
        private $contact;
    
        public function exeUpdate(array $data, int $id)
        {
            $this->data = $data;
            $this->id = $id;
            $this->contact = (new Contact())->findById($this->id);
            $this->update();
        }
    
        public function result()
        {
            return $this->result;
        }
    
        public function error()
        {
            return $this->error;
        }
    
        private function update()
        {
            $this->contact->phone = $this->data['phone'];
            $this->contact->email = $this->data['email'];
            $this->contact->address = $this->data['address'];
        
            $update = $this->contact->save();
        
            if (!$update):
                $this->error = [
                    "<b>Erro ao atualizar:</b> Não foi possível atualizar os contatos no sistema!",
                    ERROR
                ];
                $this->result = false;
            else:
                $this->error = [
                    "<b>Tudo certo:</b> Os contatos foram atualizados com sucesso!",
                    ACCEPT
                ];
                $this->result = true;
            endif;
        }
    }