<?php

namespace Source\App\Admin;

use GuzzleHttp\Client;
use League\Plates\Engine;
use Source\Models\Admin\AdminDash;
use Source\Models\Admin\AdminLogin;
use Source\Models\City;
use Source\Models\District;
use Source\Models\SiteViewAgent;
use Source\Models\SiteViewOnline;
use Source\Models\SiteView;
use Source\Models\Message;
use Source\Models\Post;
use Source\Models\Record;
use Source\Models\State;

class Dash
{
    private $template;

    public function __construct($router)
    {
        $this->template = Engine::create(ADMIN, FILE_EXT);
        $this->template->addData(["router" => $router]);
    }

    public function dash()
    {
        $session = new AdminDash();
        $validate = $session->checkSession();

        if (!$validate) :
            echo $this->template->render("index");
        else :
            $now = date('Y-m-d H:i:s');
            $today = date('Y-m-d');
            $level = $_SESSION['acesso']['nivel'];
            $idUser = $_SESSION['acesso']['id'];
            $where = ($level == 3 ? "user = {$idUser}" : null);
            $whereAnd = ($level == 3 ? "user = {$idUser} AND" : null);
            /*
             * NUMBER RESUME
             */
            $records = (new Record())->find($where)->order("created_at DESC");
            $messages = (new Message())->find();
            $posts = (new Post())->find();

            $arrMonthDistricts = [];
            foreach (getMonth() as $km => $mt) :
                if ($km != '00') :
                    foreach (getNeedDistrict() as $k => $v) :
                        $arrDistricts[$k] = 0;
                        $fetchRecords = (new Record())->find("{$whereAnd} MONTH(created_at) = :month AND YEAR(created_at) = :year", "month={$km}&year=" . date('Y') . "")->order("created_at DESC")->fetch(true);
                        if ($fetchRecords) :
                            foreach ($fetchRecords as $rec) :
                                $needDistrict = (!empty($rec->district_need) ? explode(',', $rec->district_need) : false);
                                if ($needDistrict) :
                                    if (in_array($k, $needDistrict)) :
                                        $arrDistricts[$k] += 1;
                                    endif;
                                endif;
                            endforeach;
                        endif;
                    endforeach;
                    $arrMonthDistricts[$km] = $arrDistricts;
                endif;
            endforeach;

            foreach (getMethodComunication() as $k => $v) :
                $arrMethods[$k] = 0;
                $fetchRecordsMethods = $records->fetch(true);
                if ($fetchRecordsMethods) :
                    foreach ($fetchRecordsMethods as $rec) :
                        $methods = (!empty($rec->methods_comunication) ? explode(',', $rec->methods_comunication) : false);
                        if ($methods) :
                            if (in_array($k, $methods)) :
                                $arrMethods[$k] += 1;
                            endif;
                        endif;
                    endforeach;
                endif;
            endforeach;

            foreach (getTypePersonal() as $k => $v) :
                $arrTypePersonal[$k] = 0;
                $fetchRecordsPersonal = $records->fetch(true);
                if ($fetchRecordsPersonal) :
                    foreach ($fetchRecordsPersonal as $rec) :
                        if ($rec->type_personal == $k) :
                            $arrTypePersonal[$k] += 1;
                        endif;
                    endforeach;
                endif;
            endforeach;

            foreach (getGenre() as $k => $v) :
                $arrGenre[$k] = 0;
                $fetchRecordsGenre = $records->fetch(true);
                if ($fetchRecordsGenre) :
                    foreach ($fetchRecordsGenre as $rec) :
                        if ($rec->genre == $k) :
                            $arrGenre[$k] += 1;
                        endif;
                    endforeach;
                endif;
            endforeach;

            /*
             * POST VIEW
             */
            $postsViews = (new Post())->find()->order("view DESC")->limit(3)->fetch(true);
            /*
             * BROWSER
             */
            $viewBrowsers = (new SiteViewAgent())->find()->fetch(true);
            $totalViewBrowsers = 0;
            foreach ($viewBrowsers as $vb) :
                $totalViewBrowsers += $vb->views;
            endforeach;
            $browsers = (new SiteViewAgent())->find()->order("views DESC")->fetch(true);

            echo $this->template->render("painel", [
                "numberRecord" => $records->count(),
                "numberMsg" => $messages->count(),
                "numberPost" => $posts->count(),
                "graphNeedDistrict" => $arrMonthDistricts,
                "graphMethods" => $arrMethods,
                "graphTypePersonal" => $arrTypePersonal,
                "graphGenre" => $arrGenre,
                "postsViews" => $postsViews,
                "browsers" => $browsers,
                "totalViewBrowsers" => $totalViewBrowsers,
            ]);
        endif;
    }

    public function login($data)
    {
        sleep(1);
        $json = [];
        unset($data['callback']);

        $setPost = array_map("strip_tags", $data);
        $post = array_map("trim", $setPost);

        $login = new AdminLogin();
        $login->setLogin($post);

        if (!$login->result()) :
            $json['error'] = $login->error()[0];
        else :
            $json['accept'] = $login->error()[0];
            $json['redirect'] = HOME . "/admin";
            $json['time'] = 2000;
        endif;

        echo json_encode($json);
    }

    public function logout($data)
    {
        sleep(1);
        $json = [];
        unset($data['callback']);

        $logout = new AdminLogin();
        $logout->logout();
        if ($logout->result()) :
            $json['accept'] = $logout->error()[0];
            $json['redirect'] = HOME . "/admin";
            $json['time'] = 2000;
        endif;

        echo json_encode($json);
    }

    public function getStates()
    {
        $states = (new State())->find()->order("name ASC")->fetch(true);
        if ($states) :
            echo "<option value='' selected disabled>Selecione um estado</option>";
            foreach ($states as $state) :
                echo "<option value='{$state->uf}'>{$state->uf} - {$state->name}</option>";
            endforeach;
        endif;
    }

    public function getCitysByState($data)
    {
        $state = $data['state'];
        $citys = (new City())->find("uf = :uf", "uf={$state}")->order("name ASC")->fetch(true);

        if ($citys) :
            echo "<option value='' selected disabled>Selecione uma cidade</option>";
            foreach ($citys as $city) :
                echo "<option value='{$city->id}'>{$city->name}</option>";
            endforeach;
        endif;
    }

    public function getDistrictsByCity($data)
    {
        $city = $data['city'];

        $districts = (new District())->find("city = :c", "c={$city}")->fetch(true);
        if ($districts) :
            echo "<option value='' selected disabled>Selecione um bairro</option>";
            foreach ($districts as $district) :
                echo "<option value='{$district->id}'>{$district->name}</option>";
            endforeach;
        endif;
    }
}
