<?php
    
    use Source\Models\Category;
    
    $v->layout('inc/dashboard');
    if (!$category->parent):
        $pa = "Selecione uma seção";
    else:
        $p = (new Category)->findById($category->parent);
        $pa = $p->title;
    endif;
    
?>

<div class="box-full mb-50">
    <header class="pb-60">
        <h1 class="title-page f-black f-semibold mb-10">
            <i class="icon-list-nested mr-10"></i> Editar Categoria
        </h1>
        <div class="nav float_l">
            <ul>
                <li class="t-upper">
                    <a href="<?= HOME ?>"><?= COMPANY_NAME ?></a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/admin">Dashboard</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/admin/categories">Categorias</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/admin/categories/update/">Editar Categoria</a>
                </li>
            </ul>
        </div>

        <nav class="options-default j_list">
            <a href="<?= HOME ?>/admin/categories" class="btn btn-icon-medio btn-blue round"><i class="icon-arrow-left2"></i></a>
            <a rel="<?= $category->id ?>" id="delete" class="btn btn-icon-medio btn-red round j_delete" ><i class="icon-trash"></i></a>
        </nav>
    </header>
</div>

<div class="box-full">
    <div class="box box60">
        <form action="" method="post" class="j_formajax">
            <input type="hidden" class="noclear" name="callback" value="manager">
            <input type="hidden" class="noclear" name="id" value="<?= $category->id ?>">

            <label class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">
                    <span class="f-red j_tooltip" title="Este campo é obrigatório!">*</span> Nome da Categoria
                </small>
                <input type="text" name="title" required class="form input-form-larg" placeholder="Nome" value="<?= $category->title ?>">
            </label>

            <label class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">Seção da Categoria</small>
                <div class="select">
                    <select name="parent" class="select-larg">
                        <option value="<?= $category->parent ?>">&raquo; <?= $pa ?></option>
                        <?php
                            foreach ($parents as $c):
                                echo "<option value=\"{$c->id}\">{$c->title}</option>";
                            endforeach;
                        ?>
                    </select>
                </div>
            </label>

            <label class="box box100">
                <small class="small-titulo-2 f-silver f-semibold t-upper">
                    <span class="f-red j_tooltip" title="Este campo é obrigatório!">*</span> Descrição
                </small>
                <textarea type="text" class="form area-form-larg radius-p" placeholder="Descrição da Categoria" name="description" required><?= $category->description ?></textarea>
            </label>

            <div class="box box100">
                <button class="btn btn-medio float_r btn-green radius-g">
                    <i class="fa fa-check fa-r1"></i> Atualizar Categoria
                </button>
            </div>
        </form>
    </div>
</div>