<?php

use Source\Models\Contact;
use Source\Models\Social;

/*
* HOME ROUTER & CACHE
*/

if ($_SERVER['HTTP_HOST'] == 'localhost') :
    define("HOME", "https://localhost/junior");
    define("CACHE_VERSION", time());
else :
    define("HOME", "https://www.virtuconect.com.br/projetos/junior");
    define("CACHE_VERSION", "1.0.5");
endif;

/*
* DATABASE CREDENTIALS
*/
if ($_SERVER['HTTP_HOST'] == 'localhost') :
    define("DATA_LAYER_CONFIG", [
        "driver" => "mysql",
        "host" => "mariadb",
        "port" => "3306",
        "dbname" => "zequinha",
        "username" => "root",
        "passwd" => "123",
        "options" => [
            PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8",
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_OBJ,
            PDO::ATTR_CASE => PDO::CASE_NATURAL
        ]
    ]);
else :
    define("DATA_LAYER_CONFIG", [
        "driver" => "mysql",
        "host" => "localhost",
        "port" => "3306",
        "dbname" => "mazonbrasil_junior",
        "username" => "mazonbrasil_admin",
        "passwd" => 'Virtu966@#$%',
        "options" => [
            PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8",
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_OBJ,
            PDO::ATTR_CASE => PDO::CASE_NATURAL
        ]
    ]);
endif;

/*
* CSS CONSTANTS :: ERRO
*/
define('ACCEPT', 'accept');
define('INFO', 'info');
define('ALERT', 'alert');
define('ERROR', 'error');

/*
* THEMES
*/
define("THEME", "themes/Default");
define("ADMIN", "themes/Dashboard");

/*
* DOMAIN & COMPANY_NAME
*/
define("DOMAIN", "www.virtuconect.com.br/projetos/junior");
define("COMPANY_NAME", "Júnior Ferrari");

/*
* INCLUDE_PATH & SITE_KIT
*/
define("INCLUDE_PATH", HOME . "/" . THEME);
define("SITE_KIT", INCLUDE_PATH . "/images/sitekit/");

/*
* URL
*/
define("GET_URL", strip_tags(trim(filter_input(INPUT_GET, 'route', FILTER_DEFAULT))));
define("SET_URL", (empty(GET_URL) ? '' : GET_URL));
define("URL", explode('/', SET_URL));

/*
* SITE INFORMATIONS
*/
define("SITE_TITLE", "Júnior Ferrari");
define("SITE_DESC", "Bem-vindo ao site oficial do Júnior Ferrari.");

/*
* FILE VIEW EXTENSION
*/
define("FILE_EXT", "php");

/*
* SITE CONTACT
*/
$contact = (new Contact())->findById(1);
define("ADDRESS", $contact->address);
define("EMAIL", $contact->email);
define("PHONE", $contact->phone);
define("WHATSAPP_PHONE", "5591999999999");

/*
 * SITE SOCIAL
 */
$social = (new Social())->findById(1);
define('FACEBOOK', $social->facebook);
define('INSTAGRAM', $social->instagram);
define('GOOGLE', $social->google);
define('YOUTUBE', $social->youtube);
define('TWITTER', $social->twitter);
define('TELEGRAM', '@guilhermerelvasofc');
define('TIKTOK', '@juniorferrarideputado');
define('GRUPO', 'amigosdoguilhermerelvas');

define("FACEBOOK_APP", "992137740853314");

define('FACEBOOK_LINK', 'https://facebook.com/' . FACEBOOK);
define('GRUPO_LINK', 'https://www.facebook.com/groups/' . GRUPO);
define('INSTAGRAM_LINK', 'https://instagram.com/' . INSTAGRAM);
define('GOOGLE_LINK', 'https://plus.google.com/' . GOOGLE);
define('YOUTUBE_LINK', 'https://youtube.com/@' . YOUTUBE);
define('TWITTER_LINK', 'https://twitter.com/' . TWITTER);
define('TELEGRAM_LINK', 'https://t.me/' . TELEGRAM);
define('TIKTOK_LINK', 'https://tiktok.com/' . TIKTOK);
define('WHATSAPP_LINK', 'https://api.whatsapp.com/send?phone=' . WHATSAPP_PHONE);

/*
 * MAIL CREDENTIALS
 */
define("MAIL_SMTP", [
    "host" => "",
    "port" => "465",
    "secure" => "ssl",
    "user" => "",
    "pass" => "",
    "from_name" => "",
    "from_email" => ""
]);

/*
 * LIST MOHTH
 */
function getMonth(string $month = null)
{
    $arrMounth = [
        '00' => 'Nenhum',
        '01' => 'Janeiro',
        '02' => 'Fevereiro',
        '03' => 'Março',
        '04' => 'Abril',
        '05' => 'Maio',
        '06' => 'Junho',
        '07' => 'Julho',
        '08' => 'Agosto',
        '09' => 'Setembro',
        '10' => 'Outubro',
        '11' => 'Novembro',
        '12' => 'Dezembro'
    ];

    if (empty($month)) :
        return $arrMounth;
    else :
        return $arrMounth[$month];
    endif;
}

/*
 * TYPE POST
 */
function getTypePost($type = null)
{
    $arr = [
        '1' => 'Notícias',
        '2' => 'Galeria de imagem',
        '3' => 'Vídeos',
    ];

    if (empty($type)) :
        return $arr;
    else :
        return $arr[$type];
    endif;
}

function getGenre($type = null)
{
    $arr = [
        1 => "Masculino",
        2 => "Feminino",
        3 => "Não definido",
        4 => "Prefiro não informar"
    ];

    if (empty($type)) :
        return $arr;
    else :
        return $arr[$type];
    endif;
}

function getSchoolGrade($type = null)
{
    $arr = [
        1 => "Fundamental",
        2 => "Médio Incompleto",
        3 => "Médio Completo",
        4 => "Superior Incompleto",
        5 => "Superior Completo"
    ];

    if (empty($type)) :
        return $arr;
    else :
        return $arr[$type];
    endif;
}

function getError($message, $error)
{
    $class = ($error == E_USER_NOTICE ? INFO : ($error == E_USER_WARNING ? ALERT : ($error == E_USER_ERROR ? ERROR : $error)));
    if ($class == INFO) :
        $place = 'Informativo:';
    elseif ($class == ALERT) :
        $place = 'Atenção:';
    elseif ($class == ERROR) :
        $place = 'Erro:';
    else :
        $place = 'Tudo certo:';
    endif;

    $boxError = "
        <div class='error-message {$class} radius-m'>
            <h4>{$place}</h4>
            <p>{$message}</p>
        </div>
    ";

    return $boxError;
}

function getTypePersonal($id = null)
{
    $arr = [
        1 => "Líder comunitário",
        2 => "Conselheiro tutelar",
        3 => "Pastor da igreja",
        4 => "Projeto Social",
        5 => "Outro"
    ];

    if (empty($id)) :
        return $arr;
    else :
        return $arr[$id];
    endif;
}

function getMethodComunication($id = null)
{
    $arr = [
        1 => "TV",
        2 => "Rádio",
        3 => "Jornal",
        4 => "Revista",
        5 => "Facebook",
        6 => "Instagram",
        7 => "Twitter",
        8 => "WhatsApp",
        9 => "Família",
        10 => "Outro"
    ];

    if (empty($id)) :
        return $arr;
    else :
        return $arr[$id];
    endif;
}

function getNeedDistrict($id = null)
{
    $arr = [
        1 => "Segurança",
        2 => "Saúde",
        3 => "Educação",
        4 => "Saneamento",
        5 => "Moradia",
        6 => "Água",
        7 => "Esgoto",
        8 => "Luz",
        9 => "Internet",
        10 => "Asfalto",
        11 => "Esporte",
        12 => "Cultura",
        13 => "Lazer",
        14 => "Emprego",
        15 => "Transporte",
        16 => "Outro"
    ];

    if (empty($id)) :
        return $arr;
    else :
        return $arr[$id];
    endif;
}

function getNeedDistrictSanitation($id = null)
{
    $arr = [
        1 => "Ruas sem esgoto",
        2 => "Valas a céu aberto",
        3 => "Tubulações inadequadas",
        4 => "Ruas sem água da rede",
        5 => "Água da rede não tratada",
        6 => "Outro"
    ];

    if (empty($id)) :
        return $arr;
    else :
        return $arr[$id];
    endif;
}

function getNeedDistrictHealth($id = null)
{
    $arr = [
        1 => "Hospital: construção, melhorias",
        2 => "Construção de posto de saúde",
        3 => "Melhorias no posto existente: reforma, ampliação",
        4 => "Melhorias no atendimento: horários, mais profissionais, medicamentos",
        5 => "Instalação de programas especiais: idosos, gestantes, recém-nascidos",
        6 => "Programas especiais dos Governos Estadual e Federal",
        7 => "Outro"
    ];

    if (empty($id)) :
        return $arr;
    else :
        return $arr[$id];
    endif;
}

function getNeedDistrictRoads($id = null)
{
    $arr = [
        1 => "Novas estradas a construir",
        2 => "Estradas que exigem melhorias",
        3 => "Ruas sem pavimentação",
        4 => "Pontes: recuperação e novas",
        5 => "Calçadas",
        6 => "Falta de iluminação",
        7 => "Necessidades de trevos, contornos, viadutos",
        8 => "Falta de melhorias na sinalização",
        9 => "Outro"
    ];

    if (empty($id)) :
        return $arr;
    else :
        return $arr[$id];
    endif;
}

function getNeedDistrictEducation($id = null)
{
    $arr = [
        1 => "Escolas: reformas, ampliação, novas",
        2 => "Falta de professores",
        3 => "Ensino de má qualidade",
        4 => "Implantação de 10 e 2 grau",
        5 => "Creches: construção, melhorias",
        6 => "Mudanças nas normas e legislação",
        7 => "Bolsas de estudo",
        8 => "Instalação de áreas de esporte e lazer",
        9 => "Melhorias: biblioteca, videoteca. Laboratórios informáticos",
        10 => "Melhorias nas condições de trabalho e benefícios dos professores",
        11 => "Escola técnica, universidade",
        12 => "Outro"
    ];

    if (empty($id)) :
        return $arr;
    else :
        return $arr[$id];
    endif;
}

function getNeedDistrictSports($id = null)
{
    $arr = [
        1 => "Construção de áreas esportivas",
        2 => "Incentivo ao esporte amador",
        3 => "Criação de competições",
        4 => "Bolsas e outros benéficos para atletas",
        5 => "Outro"
    ];

    if (empty($id)) :
        return $arr;
    else :
        return $arr[$id];
    endif;
}

function getNeedDistrictCulture($id = null)
{
    $arr = [
        1 => "Construção de espaços culturais",
        2 => "Criação de eventos culturais",
        3 => "Incentivos à cultura",
        4 => "Outro"
    ];

    if (empty($id)) :
        return $arr;
    else :
        return $arr[$id];
    endif;
}

function getNeedDistrictEnvironment($id = null)
{
    $arr = [
        1 => "Recuperação de áreas degradadas",
        2 => "Limpeza de rios e ribeirões",
        3 => "Reflorestamento",
        4 => "Proteção da fauna e flora",
        5 => "Criação e modificações de leis ambientais",
        6 => "Projetos de combate à poluição",
        7 => "Outro"
    ];

    if (empty($id)) :
        return $arr;
    else :
        return $arr[$id];
    endif;
}


function getNeedDistrictSecurity($id = null)
{
    $arr = [
        1 => "Construção de unidades policiais",
        2 => "Falta de policiamento",
        3 => "Projeto de segurança para a região",
        4 => "Outro"
    ];

    if (empty($id)) :
        return $arr;
    else :
        return $arr[$id];
    endif;
}


function getNeedDistrictHabitation($id = null)
{
    $arr = [
        1 => "Plano habitacional para o bairro",
        2 => "Programas de lotes urbanizados",
        3 => "Melhorias habitacionais: kit sanitário etc",
        4 => "Projetos de incentivos para programas habitacionais",
        5 => "Outro"
    ];

    if (empty($id)) :
        return $arr;
    else :
        return $arr[$id];
    endif;
}


function getNeedDistrictEconomy($id = null)
{
    $arr = [
        1 => "Programa de atração de novas empresas",
        2 => "Geração de empregos",
        3 => "Apoio á agricultura",
        4 => "Apoio à micro e pequenas empresas",
        5 => "Apoio ao artesanato",
        6 => "Projeto de distrito industrial para a região",
        7 => "Programa de incentivos fiscais e econômicos para Municípios",
        8 => "Projetos de apoio a futuros empreendedores",
        9 => "Projetos de incentivos ao turismo",
        10 => "Criação de eventos: feiras, exposições",
        11 => "Outro"
    ];

    if (empty($id)) :
        return $arr;
    else :
        return $arr[$id];
    endif;
}


function getNeedDistrictTransport($id = null)
{
    $arr = [
        1 => "Acesso",
        2 => "Novas linhas",
        3 => "Ônibus",
        4 => "Van",
        5 => "Táxi",
        6 => "Mototáxi",
        7 => "Outro"
    ];

    if (empty($id)) :
        return $arr;
    else :
        return $arr[$id];
    endif;
}


function getNeedDistrictUrban($id = null)
{
    $arr = [
        1 => "Construção de praças",
        2 => "Calçadões",
        3 => "Iluminação",
        4 => "Feiras",
        5 => "Asfalto",
        6 => "Água",
        7 => "Paradas de ônibus",
        8 => "Pontos de Táxi / Mototáxi",
        9 => "Outro"
    ];

    if (empty($id)) :
        return $arr;
    else :
        return $arr[$id];
    endif;
}

function setImplodeCheckbox($data)
{
    return (!empty($data) ? implode(',', $data) : null);
}
