<?php

namespace Source\App\Web;

use League\Plates\Engine;
use CoffeeCode\Optimizer\Optimizer;

class About
{
    private $template;
    private $optimizer;

    public function __construct($router)
    {
        $this->template = Engine::create(THEME, FILE_EXT);
        $this->optimizer = new Optimizer();

        $this->template->addData([
            "router" => $router
        ]);
    }

    public function index()
    {
        echo $this->template->render("about", [
            /** MetaTags */
            "optimizer" => $this->optimizer->optimize(
                "Sobre | " . SITE_TITLE,
                SITE_DESC,
                HOME . "/sobre",
                HOME . "/theme/images/index.jpg"
            )->render()
        ]);
    }

    public function projects()
    {
        echo $this->template->render("projects", [
            /** MetaTags */
            "optimizer" => $this->optimizer->optimize(
                "Projetos | " . SITE_TITLE,
                SITE_DESC,
                HOME . "/projetos",
                HOME . "/theme/images/index.jpg"
            )->render()
        ]);
    }
    
    public function publi()
    {
        echo $this->template->render("publi", [
            /** MetaTags */
            "optimizer" => $this->optimizer->optimize(
                "Publicações | " . SITE_TITLE,
                SITE_DESC,
                HOME . "/publicacoes",
                HOME . "/theme/images/index.jpg"
            )->render()
        ]);
    }

    public function reports()
    {
        echo $this->template->render("reports", [
            /** MetaTags */
            "optimizer" => $this->optimizer->optimize(
                "Relatorias | " . SITE_TITLE,
                SITE_DESC,
                HOME . "/relatorias",
                HOME . "/theme/images/index.jpg"
            )->render()
        ]);
    }

    public function pronouncements()
    {
        echo $this->template->render("pronouncements", [
            /** MetaTags */
            "optimizer" => $this->optimizer->optimize(
                "Pronunciamentos | " . SITE_TITLE,
                SITE_DESC,
                HOME . "/pronunciamentos",
                HOME . "/theme/images/index.jpg"
            )->render()
        ]);
    }
}
