<?php

use Source\Support\Helper;
use CoffeeCode\Cropper\Cropper;

$c = new Cropper("cache");

$v->layout('inc/layout');
?>

<section class="container padding-high bg-silver">
    <div class="box100">
        <div class="content">
            <div class="box80" style="margin: 0 auto;">
                <header class="header-post t-center">
                    <h1 class="f-black f-semibold title-page mb-40"><?= $post->title ?></h1>
                    <div class="post-details flex-container flex-justify-center">
                        <p class="bg-white radius-g f-black t-upper mr-10"><i class="icon-arrow-right2 f-green"></i> <?= getTypePost($post->type) ?></p>
                        <p class="bg-white radius-g f-black t-upper mr-10"><i class="icon-arrow-right2 f-green"></i> <?= $post->getCategory()->title ?></p>
                        <p class="bg-white radius-g f-black t-upper"><i class="icon-clock1 f-green"></i> <?= date('d/m/Y H:i', strtotime($post->created_at)) ?>h</p>
                    </div>
                </header>
            </div>
        </div>
    </div>
    <div class="mb-40"></div>

    <div class="box100 padding-default bg-black">
        <div class="content">
            <div class="box80" style="margin: 0 auto;">
                <div class="video-container">
                    <iframe width="560" height="315" src="https://www.youtube.com/embed/<?= $post->video ?>" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
                </div>
            </div>
        </div>
    </div>
    <div class="mb-40"></div>

    <div class="box100">
        <div class="content">
            <div class="box80" style="margin: 0 auto;">
                <div class="post-description">
                    <div class="post-text padding-total-normal bg-white"><?= $post->description ?></div>
                </div>
            </div>
        </div>
    </div>

    <div class="box100">
        <div class="content">
            <aside class="post-sidebar box80 mt-40">
                <div>
                    <h2 class="title-page-sec f-black f-semibold mb-40">Outros Vídeos</h2>
                    <div class="content-videos second flex-container">
                        <?php
                        if ($videos) :
                            foreach ($videos as $video) :
                        ?>
                                <article class="transition">
                                    <a href="<?= HOME ?>/videos/<?= $video->uri ?>">
                                        <div class="photo">
                                            <div class="cover green2"></div>
                                            <span class="play flex-container flex-justify-center flex-itens-center bg-white round"><i class="icon-play4 f-green"></i></span>
                                            <?= Helper::image($c->make($video->cover, 600, 350), $video->title, 'img') ?>
                                        </div>
                                        <header class="bg-silver">
                                            <h2 class="f-green f-semibold"><?= $video->title ?></h2>
                                        </header>
                                    </a>
                                </article>
                        <?php
                            endforeach;
                        endif;
                        ?>
                    </div>
                </div>
            </aside>
        </div>
    </div>
</section>