<script>
    $(function() {
        $('.payment_form').submit(function(event) {
            var form = $(this);
            var typeTransaction = form.find('input[name="typeTransaction"]').val();
            var installments = form.find('#installments').val();

            if (typeTransaction == 'credit_card') {
                // CREDIT_CARD
                event.preventDefault();
                var card = {}

                card.card_holder_name = $("#form #card_holder_name").val()
                card.card_expiration_date = $("#form #card_expiration_date").val()
                card.card_number = $("#form #card_number").val().replace(" ", '').replace(" ", '').replace(" ", '')
                card.card_cvv = $("#form #card_cvv").val()

                // CAPTURA ERROS DE VALIDAÇÃO E BANDEIRA DO CARTÃO
                var cardValidations = pagarme.validate({
                    card: card
                })

                // VERIFICA POSSÍVEIS ERROS
                if (!cardValidations.card.card_number) {
                    $('.trigger-box').html('<div class="trigger-modal error"><h4><i class="fa fa-close"></i> Erro!</h4> O número do cartão é inválido. <span class="trigger-close"><i class="fa fa-close"></i></span></div>');
                    $('.trigger-modal').fadeIn();
                } else if (!cardValidations.card.card_expiration_date) {
                    $('.trigger-box').html('<div class="trigger-modal error"><h4><i class="fa fa-close"></i> Erro!</h4> A data de expiração do cartão não é válida. <span class="trigger-close"><i class="fa fa-close"></i></span></div>');
                    $('.trigger-modal').fadeIn();
                } else {
                    pagarme.client.connect({
                            encryption_key: '<?= PAGARME['cript'] ?>'
                        })
                        .then(client => client.security.encrypt(card))
                        .then(
                            // CARD_HASH
                            function(hash) {
                                $.ajax({
                                    url: "<?= HOME ?>/matricula/payment",
                                    type: "POST",
                                    dataType: "json",
                                    data: {
                                        transaction: typeTransaction,
                                        card_hash: hash,
                                        card: card,
                                        installments: installments,
                                    },
                                    beforeSend: function() {
                                        $('.mask-modal').fadeIn();
                                        $('.form_load').fadeIn();
                                        $('.trigger-modal').fadeOut(500, function() {
                                            $(this).remove();
                                        });
                                    },
                                    success: function(response) {
                                        if (response.error) {
                                            $('.trigger-box').html('<div class="trigger-modal error"><h4><i class="fa fa-close"></i> Erro!</h4> ' + response.error + ' <span class="trigger-close"><i class="fa fa-close"></i></span></div>');
                                            $('.trigger-modal').fadeIn();
                                        } else {
                                            $('.trigger-box').html('<div class="trigger-modal accept"><h4><i class="fa fa-check"></i> Tudo certo!</h4> ' + response.accept + ' <span class="trigger-close"><i class="fa fa-close"></i></span></div>');
                                            $('.trigger-modal').fadeIn();

                                            if (response.prev) {
                                                $(response.prev).fadeOut(function() {
                                                    $(response.next).fadeIn();
                                                });
                                            }

                                            if (response.result_order) {
                                                $('.resultOrderSelected').html(response.result_order);
                                            }
                                        }

                                        $('.mask-modal').fadeOut();
                                        $('.form_load').fadeOut();
                                    }
                                });
                            }
                        );
                }
            } else {
                pagarme.client.connect({
                        encryption_key: '<?= PAGARME['cript'] ?>'
                    })
                    .then(
                        function() {
                            $.ajax({
                                url: "<?= HOME ?>/matricula/payment",
                                type: "POST",
                                dataType: "json",
                                data: {
                                    transaction: typeTransaction,
                                },
                                beforeSend: function() {
                                    $('.mask-modal').fadeIn();
                                    $('.form_load').fadeIn();
                                    $('.trigger-modal').fadeOut(500, function() {
                                        $(this).remove();
                                    });
                                },
                                success: function(response) {
                                    if (response.error) {
                                        $('.trigger-box').html('<div class="trigger-modal error"><h4><i class="fa fa-close"></i> Erro!</h4> ' + response.error + ' <span class="trigger-close"><i class="fa fa-close"></i></span></div>');
                                        $('.trigger-modal').fadeIn();
                                    } else {
                                        $('.trigger-box').html('<div class="trigger-modal accept"><h4><i class="fa fa-check"></i> Tudo certo!</h4> ' + response.accept + ' <span class="trigger-close"><i class="fa fa-close"></i></span></div>');
                                        $('.trigger-modal').fadeIn();

                                        if (response.prev) {
                                            $(response.prev).fadeOut(function() {
                                                $(response.next).fadeIn();
                                            });
                                        }

                                        if (response.result_order) {
                                            $('.resultOrderSelected').html(response.result_order);
                                        }

                                        if (response.billet) {
                                            window.open(response.billet, "_blank");
                                        }
                                    }

                                    $('.mask-modal').fadeOut();
                                    $('.form_load').fadeOut();
                                }
                            });
                        }
                    );
            }
            return false
        });

        // CARD NAME
        $('#card_holder_name').keyup(function() {
            $(this).val(function(i, val) {
                return val.toUpperCase();
            });
        });
    });

    // NUMBER ONLY
    function wcIsNumericHit(evt) {
        var charCode = (evt.which) ? evt.which : event.keyCode;
        if (charCode > 31 && (charCode < 48 || charCode > 57)) {
            return false;
        }
        return true;
    }
</script>