<?php
$v->layout('inc/dashboard');
?>

<div class="box-full mb-50">
    <header class="pb-60">
        <h1 class="title-page f-black f-semibold mb-10">
            <i class="icon-write mr-10"></i> Cadastros
        </h1>
        <div class="nav float_l">
            <ul>
                <li class="t-upper">
                    <a href="<?= HOME ?>"><?= COMPANY_NAME ?></a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/admin">Dashboard</a>
                    <i class="fa fa-angle-right"></i>
                </li>
                <li class="t-upper">
                    <a href="<?= HOME ?>/admin/records">Cadastros</a>
                </li>
            </ul>
        </div>

        <nav class="options-default">
            <a href="<?= HOME ?>/admin/records/create" class="btn btn-medio btn-blue radius-g"><i class="icon-write"></i> Novo cadastro</a>
        </nav>
    </header>
</div>

<div class="box-full">
    <div class="box box100">
        <?php
        if ($records) :
            $color = 'box-silver';
            $i = 0;
        ?>
            <div class="content-table">
                <table class="table box-full" cellspacing="0" cellpadding="0">
                    <tr class="box-silver t-upper">
                        <td class="f-bold f-black tb-field">#</td>
                        <td class="f-bold f-black tb-field" style="width: 30%;">Entrevistado</td>
                        <td class="f-bold f-black tb-field">Responsável</td>
                        <td class="f-bold f-black tb-field">Localidade</td>
                        <td class="f-bold f-black tb-field">Cadastrado em</td>
                        <td class="f-bold f-black tb-field">&nbsp;</td>
                    </tr>
                    <?php
                    foreach ($records as $rec) :
                        $i++;
                        $color = ($color == 'box-silver' ? 'box-white' : 'box-silver');
                        $i = ($i <= 9 ? '0' . $i : $i);
                    ?>
                        <tr class="<?= $color ?>">
                            <td class="f-light f-black tb-field"><?= $i ?></td>
                            <td class="f-light f-black tb-field" style="width: 30%;">
                                <b class="f-semibold"><?= $rec->name . ' ' . $rec->lastname ?></b>
                                <small class="small-titulo f-silver f-light" style="margin-top: 2px;"><i class="icon-user2"></i> <?= getGenre($rec->genre) ?></small>
                                <small class="small-titulo f-silver f-light"><i class="icon-whatsapp"></i> <?= $rec->phone ?></small>
                            </td>
                            <td class="f-light f-black tb-field"><?= $rec->getUser()->name ?></td>
                            <td class="f-light f-black tb-field"><?= $rec->getCity()->name . '/' . $rec->state . ' - ' . $rec->getDistrict()->name ?></td>
                            <td class="f-light f-black tb-field"><?= date('d/m/Y H:i', strtotime($rec->created_at)) ?>h</td>
                            <td class="f-light f-black tb-field j_list t-right">
                                <a href="<?= HOME ?>/admin/records/view/<?= $rec->id ?>" class="btn btn-icon-medio btn-blue round"><i class="icon-eye1"></i></a>
                            </td>
                        </tr>
                    <?php
                    endforeach;
                    ?>
                </table>
            </div>
            <div class="t-right mt-30">
                <?= $paginator ?>
            </div>
        <?php else : ?>
            <div class="box-full box-white padding-total-normal radius-m">
                <h2 class="title-page-sec f-semibold f-black">Nada encontrado</h2>
                <p class="text-page f-light f-black mt-10">Não foi possível encontrar nenhum cadastro até o momento.</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<div class="trigger-box"></div>