<?php
    
    namespace Source\Models\Admin;
    
    use Source\Support\Helper;
    use Source\Models\Category;
    use Source\Models\Post;
    
    class AdminCategory
    {
        private $data;
        private $result;
        private $error;
        private $cate;
        private $id;
        
        public function exeCreate(array $data)
        {
            $this->data = $data;
            
            if (in_array('', $this->data)):
                $this->result = false;
                $this->error = [
                    "<b class='f-bold'>Erro ao cadastrar:</b> Você precisa preencher todos os campos para cadastrar uma categoria.",
                    ERROR
                ];
            else:
                $this->uri();
                $this->create();
            endif;
        }
        
        public function exeUpdate(array $data, int $id)
        {
            $this->data = $data;
            $this->id = $id;
            
            if (in_array('', $this->data)):
                $this->result = false;
                $this->error = [
                    "<b class='f-bold'>Erro ao cadastrar:</b> Você precisa preencher todos os campos para cadastrar uma categoria.",
                    ERROR
                ];
            else:
                $this->uri();
                $this->update();
            endif;
        }
        
        public function exeDelete(int $id)
        {
            $this->id = $id;
            $this->cate = (new Category())->findById($this->id);
            if (!$this->cate):
                $this->result = false;
                $this->error = [
                    "<b class='f-bold'>Erro ao excluir:</b> A categoria que você está tentando excluir não foi encontrada.",
                    ERROR
                ];
            else:
                $this->checkCate();
                if ($this->result):
                    $this->checkPost();
                    if ($this->result):
                        $delete = $this->cate->destroy();
                        if (!$delete):
                            $this->result = false;
                            $this->error = [
                                "<b class='f-bold'>Erro ao excluir:</b> Ocorreu um erro ao excluir esta categoria.",
                                ERROR
                            ];
                        else:
                            $this->result = true;
                            $this->error = [
                                "<b class='f-bold'>Tudo certo:</b> A categoria foi excluída com sucesso do sistema.",
                                ACCEPT
                            ];
                        endif;
                    endif;
                endif;
            endif;
        }
        
        public function result()
        {
            return $this->result;
        }
        
        public function error()
        {
            return $this->error;
        }
        
        private function uri()
        {
            $this->data['uri'] = Helper::uri($this->data['title']);
        }
        
        private function checkPost()
        {
            if ($this->cate->parent == 0):
                $posts = (new Post())->find("parent = :p", "p={$this->id}")->fetch(true);
            else:
                $posts = (new Post())->find("category = :c", "c={$this->id}")->fetch(true);
            endif;
            
            if ($posts):
                $this->result = false;
                $this->error = [
                    "<b class='f-bold'>Erro ao excluir:</b> Esta categoria possui posts vinculados, exclua as posts antes de excluir a categoria.",
                    ERROR
                ];
            else:
                $this->result = true;
            endif;
        }
        
        private function checkCate()
        {
            $cate = (new Category())->find("parent = :p", "p={$this->id}")->fetch(true);
            if ($cate):
                $this->result = false;
                $this->error = [
                    "<b class='f-bold'>Erro ao excluir:</b> Esta seção possui categorias internas, exclua as categorias antes de excluir a seção.",
                    ERROR
                ];
            else:
                $this->result = true;
            endif;
        }
        
        private function create()
        {
            $this->cate = new Category();
            
            $this->cate->title = $this->data['title'];
            $this->cate->uri = $this->data['uri'];
            $this->cate->description = $this->data['description'];
            $this->cate->parent = $this->data['parent'];
            
            $create = $this->cate->save();
            if (!$create):
                $this->result = false;
                $this->error = [
                    "<b class='f-bold'>Erro ao cadastrar:</b> Não foi possível cadastrar a categoria no sistema!",
                    ERROR
                ];
            else:
                $this->result = $this->cate->data()->id;
                $this->error = [
                    "<b class='f-bold'>Tudo certo:</b> A categoria foi cadastrada com sucesso no sistema!",
                    ACCEPT
                ];
            endif;
        }
        
        private function update()
        {
            $this->cate = (new Category())->findById($this->id);
            
            $this->cate->title = $this->data['title'];
            $this->cate->uri = $this->data['uri'];
            $this->cate->description = $this->data['description'];
            $this->cate->parent = $this->data['parent'];
            
            $update = $this->cate->save();
            if (!$update):
                $this->result = false;
                $this->error = [
                    "<b class='f-bold'>Erro ao atualizar:</b> Não foi possível atualizar a categoria no sistema!",
                    ERROR
                ];
            else:
                $this->result = true;
                $this->error = [
                    "<b class='f-bold'>Tudo certo:</b> A categoria foi atualizada com sucesso no sistema!",
                    ACCEPT
                ];
            endif;
        }
    }