$(function () {
    // AJAX SUBMIT DEFAULT
    $('.j_formajax').submit(function () {
        var form = $(this);
        var callback = form.find('input[name="callback"]').val();

        if (typeof tinyMCE !== 'undefined') {
            tinyMCE.triggerSave();
        }

        form.ajaxSubmit({
            url: callback,
            type: 'POST',
            dataType: 'json',
            beforeSend: function () {
                $('.mask-modal').fadeIn();
                $('.form_load').fadeIn();
                $('.trigger-box .trigger-modal').fadeOut(function () {
                    $(this).remove();
                });
            },
            success: function (resposta) {
                console.clear();
                console.log(resposta);

                if (resposta.error) {
                    $('.trigger-box').html('<div class="trigger-modal error"><h4><i class="fa fa-close"></i> Erro!</h4> ' + resposta.error + ' <span class="trigger-close"><i class="fa fa-close"></i></span></div>');
                    $('.trigger-modal').fadeIn();
                } else {
                    $('.trigger-box').html('<div class="trigger-modal accept"><h4><i class="fa fa-check"></i> Tudo certo!</h4> ' + resposta.accept + ' <span class="trigger-close"><i class="fa fa-close"></i></span></div>');
                    $('.trigger-modal').fadeIn();

                    if (resposta.redirect) {
                        setTimeout(function () {
                            location.href = resposta.redirect;
                        }, resposta.time);
                    }

                    if (resposta.result) {
                        $(resposta.result).prependTo($('.j_newresult'));
                        $('.j_new').fadeIn();
                    }

                    if (resposta.replace) {
                        $('.j_replace').fadeOut(function () {
                            $(this).remove();
                        });

                        $('.j_replacebox').html(resposta.replace);
                        $('.j_replace').fadeIn();
                    }

                    if (resposta.clear) {
                        form.find('input[class!="noclear"], textarea').val('');
                    }
                }

                if (responsa.mask) {
                    $('.mask-modal').fadeOut();
                }

                $('.form_load').fadeOut();
                $('.handleFinishAvaliation').fadeOut();

                $('.trigger-modal .trigger-close').click(function () {
                    $('.trigger-box .trigger-modal').fadeOut(function () {
                        $(this).remove();
                    });
                });
            }
        });
        return false;
    });

    $('.j_formcheckoutajax').submit(function () {
        var form = $(this);
        var callback = form.find('input[name="callback"]').val();

        form.ajaxSubmit({
            url: callback,
            type: 'POST',
            dataType: 'json',
            beforeSend: function () {
                $('.mask-modal').fadeIn();
                $('.form_load').fadeIn();
                $('.trigger-box .trigger-modal').fadeOut(function () {
                    $(this).remove();
                });
            },
            success: function (response) {
                console.clear();
                console.log(response);

                if (response.error) {
                    $('.trigger-box').html('<div class="trigger-modal error"><h4><i class="fa fa-close"></i> Erro!</h4> ' + response.error + ' <span class="trigger-close"><i class="fa fa-close"></i></span></div>');
                    $('.trigger-modal').fadeIn();
                } else {
                    if (response.result_client) {
                        $('.resultClientSelected').html(response.result_client);
                    }

                    if (response.result_service) {
                        $('.resultServiceSelected').html(response.result_service);
                    }

                    if (response.installments) {
                        $('#installments').html(response.installments);
                    }

                    if (response.prev) {
                        $(response.prev).fadeOut(function () {
                            $(response.next).fadeIn();
                        });
                    }
                }

                $('.mask-modal').fadeOut();
                $('.form_load').fadeOut();

                $('.trigger-modal .trigger-close').click(function () {
                    $('.trigger-box .trigger-modal').fadeOut(function () {
                        $(this).remove();
                    });
                });
            }
        });
        return false;
    });

    //DELETA DADOS 
    $('.j_list').on('click', '.j_delete', function () {
        var id = $(this).attr('rel');
        var action = $(this).attr('role');
        var callback = $(this).attr('id');

        if (!confirm("Você tem certeza que deseja deletar este item?")) {
            return false;
        }
        $.ajax({
            url: '_ajax/ajax' + callback + '.php',
            data: {
                action: action,
                id: id
            },
            type: 'POST',
            dataType: 'json',
            beforeSend: function () {
                $('.trigger-modal').fadeOut(500, function () {
                    $(this).remove();
                });
            },
            success: function (resposta) {
                if (resposta.error) {
                    $('.trigger-box').html('<div class="trigger-modal"><span class="close-modal"><i class="fa fa-close"></i></span><div class="trigger alert">' + resposta.error + '</div></div>');
                    $('.trigger-modal').fadeIn();
                } else {
                    $('.trigger-box').html('<div class="trigger-modal"><span class="close-modal"><i class="fa fa-close"></i></span><div class="trigger accept">' + resposta.accept + '</div></div>');
                    $('.trigger-modal').fadeIn();
                    $('.j_list #' + id).fadeOut();

                    if (resposta.redirect) {
                        setTimeout(function () {
                            location.href = resposta.redirect;
                        }, resposta.time);
                    }
                }

                // FECHA MODAL SUCESS
                $('.trigger-modal .close-modal').click(function () {
                    $('.trigger-modal').fadeOut();
                });
            }
        });
    });

    $('.handleOpenUnity').click(function () {
        let unity = $(this).attr('unity');
        let callback = $(this).attr('callback');
        let box = $('.resultModalUnity');

        $.ajax({
            url: callback,
            data: {
                id: unity
            },
            type: 'POST',
            dataType: 'json',
            beforeSend: function () {
                box.html('');
            },
            success: function (response) {
                box.html(response.result);
            }
        });
    });

    $('.handleOpenSetClient').click(function () {
        let avaliation = $(this).attr('avaliation');
        let input = $('#avaliationId');
        input.val(avaliation);
    });
});