<?php

use Source\Support\Helper;
use CoffeeCode\Cropper\Cropper;

$c = new Cropper("cache");
$v->layout('inc/layout');
?>

<section class="container content-news-welcome">
    <div class="slider_news">
        <?php
        if ($postsBanner) :
            foreach ($postsBanner as $post) :
        ?>
                <a href="<?= HOME ?>/noticias/<?= $post->uri ?>">
                    <article class="wall" style="background-image: url(<?= HOME ?>/<?= $post->cover ?>);">
                        <div class="content flex-container flex-itens-center">
                            <header>
                                <h1 class="f-semibold"><span class="bg-green f-white"><?= $post->title ?></span></h1>
                            </header>
                        </div>
                    </article>
                </a>
        <?php
            endforeach;
        endif;
        ?>
    </div>
    <div class="box-arrows-news flex-container flex-itens-center flex-justify-center">
        <span class="arrows-news transition prev-news f-white"><i class="fa fa-angle-left"></i></span>
        <span class="arrows-news transition next-news f-white ml-40"><i class="fa fa-angle-right"></i></span>
    </div>
</section>

<section class="container">
    <div class="content-other-news flex-container">
        <?php
        if ($postsSecond) :
            foreach ($postsSecond as $post) :
        ?>
                <a href="<?= HOME ?>/noticias/<?= $post->uri ?>" class="flex33">
                    <article class="wall flex-container flex-direction-column flex-justify-end" style="background-image: url(<?= HOME ?>/<?= $post->cover ?>);">
                        <header class="shadow-title transition">
                            <h1 class="f-semibold f-white transition"><?= $post->title ?></h1>
                        </header>
                    </article>
                </a>
        <?php
            endforeach;
        endif;
        ?>

        <article class="bg-green newsletter flex33">
            <h2 class="f-white f-semibold mb-10">Quer ficar por dentro?</h2>
            <p class="f-white f-elight">Então inscreva-se em nossa newsletter!</p>
            <div class="box-form mt-20">
                <form action="" class="flex-container" method="post">
                    <input type="email" name="email" placeholder="Seu melhor e-mail:" required>
                    <button class="btn-green ml-20 flex-container flex-itens-center flex-justify-center"><i class="icon-checkmark1 f-white"></i></button>
                </form>
            </div>
        </article>
    </div>
</section>

<section class="container padding-high wall" style="background-image: url(<?= INCLUDE_PATH ?>/images/wall2.jpg);">
    <div class="content">
        <header class="header-default box50 mb-20">
            <h1 class="f-semibold" style="color: rgba(139,202,167,0.5)">Biografia</h1>
            <div>
                <h2 class="f-green f-semibold">Conheça o Portal Cristão Pará</h2>
            </div>
        </header>
        <p class="f-light subtitle-page f-black box50">
            Nasceu em Araguacema, no Tocantins, em 18 em de setembro de 1959. Trabalhou como comerciário, técnico em contabilidade e servidor público municipal. É funcionário licenciado do Banco da Amazônia. Formou-se em Pedagogia pela Universidade do Estado do Pará (UEPA), em Teologia pela Faculdade João Calvino (DF) e Contabilidade pela Fundação Bradesco – Escola Ministro Jarbas Gonçalves Passarinho – Conceição do Araguaia – Pará. 
        </p>

        <!--<div class="content-about-itens box50 flex-container flex-wrap mt-20">
            <?php
            for ($i = 1; $i <= 4; $i++) :
                $icon = ($i == 1 ? 'user2' : ($i == 2 ? 'books' : ($i == 3 ? 'paste' : 'microphone')));
                $title = ($i == 1 ? 'Biografia' : ($i == 2 ? 'Projetos' : ($i == 3 ? 'Relatorias' : 'Pronunciamentos')));
                $link = Helper::uri($title);
            ?>

                <article>
                    <a href="<?= HOME ?>/<?= $link ?>" class="flex-container flex-itens-center">
                        <div class="icon transition bg-white flex-container flex-itens-center flex-justify-center">
                            <i class="icon-<?= $icon ?>"></i>
                        </div>
                        <header class="bg-white transition ml-10 flex-container flex-itens-center pl-20">
                            <h2 class="f-semibold f-green"><?= $title ?></h2>
                        </header>
                    </a>
                </article>
            <?php
            endfor;
            ?>
        </div>-->
    </div>
</section>

<section class="container padding-high wall" style="background-image: url(<?= INCLUDE_PATH ?>/images/wall3.jpg);">
    <div class="cover green"></div>
    <div class="content">
        <header class="header-default t-center mb-100">
            <h1 class="f-semibold" style="color: rgba(255,255,255,0.2)">Vídeos</h1>
            <h2 class="f-semibold f-white">TV Cristão</h2>
        </header>

        <div class="content-videos flex-container">
            <?php
            if ($videos) :
                foreach ($videos as $video) :
            ?>
                    <article class="transition">
                        <a href="<?= HOME ?>/videos/<?= $video->uri ?>">
                            <div class="photo">
                                <div class="cover green2"></div>
                                <span class="play flex-container flex-justify-center flex-itens-center bg-white round"><i class="icon-play4 f-green"></i></span>
                                <?= Helper::image($c->make($video->cover, 600, 350), $video->title, 'img') ?>
                            </div>
                            <header class="bg-white">
                                <h2 class="f-green f-semibold"><?= $video->title ?></h2>
                            </header>
                        </a>
                    </article>
            <?php
                endforeach;
            endif;
            ?>
        </div>
    </div>
</section>

<section class="container padding-high bg-white">
    <div class="content">
        <header class="header-default t-center mb-10">
            <h1 class="f-semibold" style="color: rgba(0, 0, 0, 0.2)">Redes Sociais</h1>
            <h2 class="f-semibold f-black">Acompanhe o Cristão Pará</h2>
        </header>
        <p class="text-page f-silver f-light t-center">Siga os nossos canais digitais e acompanhe tudo sobre o mundo cristão.</p>

        <div class="content-social-home flex-container mt-80">
            <article class="facebook wall" style="background-image: url(<?= INCLUDE_PATH ?>/images/img1.jpg);">
                <div class="cover"></div>
                <div class="social flex-container flex-direction-column flex-justify-space-between">
                    <div class="title">
                        <i class="icon-facebook f-white"></i>
                        <h1 class="f-white f-light mt-20">Acompanhe no <strong class="f-semibold">Facebook</strong></h1>
                    </div>
                    <a href="<?= FACEBOOK_LINK ?>" target="_blank" class="btn btn-medio btn-white">Acompanhe!</a>
                </div>
            </article>

            <article class="instagram wall" style="background-image: url(<?= INCLUDE_PATH ?>/images/img3.jpg);">
                <div class="cover"></div>
                <div class="social flex-container flex-direction-column flex-justify-space-between">
                    <div class="title">
                        <i class="icon-instagram f-white"></i>
                        <h1 class="f-white f-light mt-20">Siga no <strong class="f-semibold">Instagram</strong></h1>
                    </div>
                    <a href="<?= INSTAGRAM_LINK ?>" target="_blank" class="btn btn-medio btn-white">Siga-nos!</a>
                </div>
            </article>
            
            <!--<article class="twitter wall" style="background-image: url(<?= INCLUDE_PATH ?>/images/img3.jpg);">
                <div class="cover"></div>
                <div class="social flex-container flex-direction-column flex-justify-space-between">
                    <div class="title">
                        <i class="icon-twitter f-white"></i>
                        <h1 class="f-white f-light mt-20">Siga no <strong class="f-semibold">Twitter</strong></h1>
                    </div>
                    <a href="<?= TWITTER_LINK ?>" target="_blank" class="btn btn-medio btn-white">Siga-nos!</a>
                </div>
            </article>-->

            <article class="whatsapp wall" style="background-image: url(<?= INCLUDE_PATH ?>/images/img4.jpg);">
                <div class="cover"></div>
                <div class="social flex-container flex-direction-column flex-justify-space-between">
                    <div class="title">
                        <i class="icon-whatsapp f-white"></i>
                        <h1 class="f-white f-light mt-20">Fale conosco no <strong class="f-semibold">Whastapp</strong></h1>
                    </div>
                    <a href="<?= WHATSAPP_LINK ?>" target="_blank" class="btn btn-medio btn-white">Fale conosco!</a>
                </div>
            </article>

            <article class="telegram wall" style="background-image: url(<?= INCLUDE_PATH ?>/images/img5.jpg);">
                <div class="cover"></div>
                <div class="social flex-container flex-direction-column flex-justify-space-between">
                    <div class="title">
                        <i class="icon-telegram f-white"></i>
                        <h1 class="f-white f-light mt-20">Acompanhe no <strong class="f-semibold">Telegram</strong></h1>
                    </div>
                    <a href="<?= TELEGRAM_LINK ?>" target="_blank" class="btn btn-medio btn-white">Faça parte!</a>
                </div>
            </article>
        </div>
    </div>
</section>