<?php

namespace Source\App\Admin;

use CoffeeCode\Paginator\Paginator;
use GuzzleHttp\Client;
use League\Plates\Engine;
use Source\Models\Admin\AdminDash;
use Source\Models\City;
use Source\Models\District;
use Source\Models\Record as ModelsRecord;
use Source\Models\State;

class Record
{
    private $template;

    public function __construct($router)
    {
        $session = new AdminDash();
        $validate = $session->checkSession();
        if (!$validate) :
            header('Location:' . HOME . "/admin");
        endif;

        $checkLevel = $session->checkLevel($_SESSION['acesso']['nivel'], [1, 2, 3]);
        if (!$checkLevel) :
            header('Location:' . HOME . "/admin");
        endif;

        $this->template = Engine::create(ADMIN, FILE_EXT);
        $this->template->addData(["router" => $router]);
    }

    public function index()
    {
        $level = $_SESSION['acesso']['nivel'];
        $idUser = $_SESSION['acesso']['id'];
        $page = filter_input(INPUT_GET, 'page', FILTER_VALIDATE_INT);
        $rec = new ModelsRecord();
        $where = ($level == 3 ? "user = {$idUser}" : null);

        $paginator = new Paginator(HOME . "/admin/records&page=", "Página", [
            "Primeira Página",
            "Primeira"
        ], [
            "Última Página",
            "Última"
        ]);
        $paginator->pager($rec->find($where)->count(), 50, $page, 2);
        $records = $rec->find($where)
            ->order("created_at DESC")
            ->limit($paginator->limit())
            ->offset($paginator->offset())
            ->fetch(true);

        echo $this->template->render("system/records/index", [
            "records" => $records,
            "paginator" => $paginator->render()
        ]);
    }

    public function create()
    {
        $states = (new State())->find()->order("name ASC")->fetch(true);
        $citys = (new City())->find("uf = :uf", "uf=PA")->fetch(true);
        echo $this->template->render("system/records/create", [
            "states" => $states,
            "citys" => $citys
        ]);
    }

    public function view($data)
    {
        $level = $_SESSION['acesso']['nivel'];
        $idUser = $_SESSION['acesso']['id'];

        if (empty($data['id'])) :
            header('Location:' . HOME . '/admin/records');
        endif;

        $record = (new ModelsRecord())->findById($data['id']);
        if (!$record) :
            header('Location:' . HOME . '/admin/records');
        elseif ($level == 3 && $record->user != $idUser) :
            header('Location:' . HOME . '/admin/records');
        endif;

        $citys = (new City())->find("uf = :uf", "uf=PA")->fetch(true);
        $districts = (new District())->find("city = :c", "c={$record->city}")->fetch(true);

        echo $this->template->render("system/records/view", [
            "record" => $record,
            "citys" => $citys,
            "districts" => $districts
        ]);
    }

    public function manager($data)
    {
        sleep(1);
        $json = [];

        /** DADOS DE PESQUISA */
        $methodsComunication = (isset($data['methods_comunication']) ? $data['methods_comunication'] : null);
        $districtNeed = (isset($data['district_need']) ? $data['district_need'] : null);
        $districtNeedHealth = (isset($data['district_need_health']) ? $data['district_need_health'] : null);
        $districtNeedEducation = (isset($data['district_need_education']) ? $data['district_need_education'] : null);
        $districtNeedSecurity = (isset($data['district_need_security']) ? $data['district_need_security'] : null);
        $districtNeedRoads = (isset($data['district_need_roads']) ? $data['district_need_roads'] : null);
        $districtNeedSanitation = (isset($data['district_need_sanitation']) ? $data['district_need_sanitation'] : null);
        $districtNeedSports = (isset($data['district_need_sports']) ? $data['district_need_sports'] : null);
        $districtNeedCulture = (isset($data['district_need_culture']) ? $data['district_need_culture'] : null);
        $districtNeedHabitation = (isset($data['district_need_habitation']) ? $data['district_need_habitation'] : null);
        $districtNeedEnvironment = (isset($data['district_need_environment']) ? $data['district_need_environment'] : null);
        $districtNeedEconomy = (isset($data['district_need_economy']) ? $data['district_need_economy'] : null);
        $districtNeedTransport = (isset($data['district_need_transport']) ? $data['district_need_transport'] : null);
        $districtNeedUrban = (isset($data['district_need_urban']) ? $data['district_need_urban'] : null);
        unset($data['methods_comunication']);
        unset($data['district_need']);
        unset($data['district_need_health']);
        unset($data['district_need_education']);
        unset($data['district_need_security']);
        unset($data['district_need_roads']);
        unset($data['district_need_sanitation']);
        unset($data['district_need_sports']);
        unset($data['district_need_culture']);
        unset($data['district_need_habitation']);
        unset($data['district_need_environment']);
        unset($data['district_need_economy']);
        unset($data['district_need_transport']);
        unset($data['district_need_urban']);

        $setPost = array_map("strip_tags", $data);
        $post = array_map("trim", $setPost);

        if (in_array('', $post)) :
            $json['error'] = "Você precisa preencher todos os campos obrigatórios.";
            echo json_encode($json);
            return;
        endif;

        $record = (isset($post['id']) ? (new ModelsRecord())->findById($post['id']) : new ModelsRecord());
        $record->name = $post['name'];
        $record->lastname = $post['lastname'];
        $record->user = $_SESSION['acesso']['id'];
        $record->genre = $post['genre'];
        $record->birth = $post['birth'];
        $record->phone = $post['phone'];
        $record->state = 'PA';
        $record->city = $post['city'];
        $record->district = $post['district'];
        $record->type_personal = $post['type_personal'];
        $record->methods_comunication = setImplodeCheckbox($methodsComunication);
        $record->district_need = setImplodeCheckbox($districtNeed);
        $record->district_need_health = setImplodeCheckbox($districtNeedHealth);
        $record->district_need_education = setImplodeCheckbox($districtNeedEducation);
        $record->district_need_security = setImplodeCheckbox($districtNeedSecurity);
        $record->district_need_roads = setImplodeCheckbox($districtNeedRoads);
        $record->district_need_sanitation = setImplodeCheckbox($districtNeedSanitation);
        $record->district_need_sports = setImplodeCheckbox($districtNeedSports);
        $record->district_need_culture = setImplodeCheckbox($districtNeedCulture);
        $record->district_need_habitation = setImplodeCheckbox($districtNeedHabitation);
        $record->district_need_environment = setImplodeCheckbox($districtNeedEnvironment);
        $record->district_need_economy = setImplodeCheckbox($districtNeedEconomy);
        $record->district_need_transport = setImplodeCheckbox($districtNeedTransport);
        $record->district_need_urban = setImplodeCheckbox($districtNeedUrban);

        if (!$record->save()) :
            $json['error'] = $record->fail()->getMessage();
            echo json_encode($json);
            return;
        endif;

        if (isset($post['id'])) :
            $json['accept'] = "O cadastro foi atualizado com sucesso!";
        else :
            $json['accept'] = "O cadastro foi realizado com sucesso!";
            $json['redirect'] = HOME . "/admin/records";
            $json['time'] = 2000;
        endif;

        echo json_encode($json);
    }
}
