const shareButtons = document.querySelectorAll(".share");

shareButtons.forEach((button) => {
  button.addEventListener("click", () => {
    const link = button.parentElement.querySelector(".links").href;

    // Opções de compartilhamento para dispositivos móveis (navegador nativo)
    if (navigator.share) {
      navigator
        .share({
          title: "Compartilhar página UGS",
          url: link,
        })
        .then(() => console.log("Link compartilhado"))
        .catch((error) => console.error("Erro ao compartilhar:", error));
    } else {
      // Opções de compartilhamento para dispositivos desktop (cópia manual)
      copyToClipboard(link);
      alert("Link copiado para a área de transferência!");
    }
  });
});

function copyToClipboard(text) {
  const tempInput = document.createElement("input");
  tempInput.value = text;
  document.body.appendChild(tempInput);
  tempInput.select();
  document.execCommand("copy");
  document.body.removeChild(tempInput);
}
